/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.bo;

import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.time.XMLGregorianCalendarUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.xml.datatype.DatatypeConfigurationException;

public class RowTypeSGDLINEUPExtractor
implements RowExtractor<RowTypeSGDLINEUP> {
    private final boolean isEtv18;

    public RowTypeSGDLINEUPExtractor(boolean isEtv18) {
        this.isEtv18 = isEtv18;
    }

    public RowTypeSGDLINEUP extract(ResultSet rs) throws DatatypeConfigurationException, SQLException {
        String device = rs.getString("device");
        RowTypeSGDLINEUP rowLineup = new RowTypeSGDLINEUP();
        rowLineup.setCLROWID(rs.getBigDecimal("lineup_id"));
        rowLineup.setCLSTATIONNUM(rs.getString("station_id"));
        rowLineup.setCLHEADENDID(rs.getString("headend_id"));
        if (!this.isEtv18) {
            rowLineup.setCLDEVICE(device);
        } else if (device != null && device.equalsIgnoreCase("X")) {
            rowLineup.setCLDEVICE("X");
        } else if (device != null) {
            rowLineup.setCLDEVICE(" ");
        }
        rowLineup.setCLTMSCHAN(rs.getString("tms_channel"));
        rowLineup.setCLSERVICETIER(rs.getString("service_tier"));
        rowLineup.setCLEFFECTIVEDATE(XMLGregorianCalendarUtil.getXMLDate((Timestamp)rs.getTimestamp("effective_date")));
        rowLineup.setCLEXPIRATIONDATE(XMLGregorianCalendarUtil.getXMLDate((Timestamp)rs.getTimestamp("expiration_date")));
        return rowLineup;
    }
}

