/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.bo;

import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.SeriesInformation;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;
import com.ericsson.cms.epgmgmt.utility.time.XMLGregorianCalendarUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.lang.StringUtils;

public class RowTypeSGDSCHEDULEExtractor
implements RowExtractor<RowTypeSGDSCHEDULE> {
    private static final int NUMBER_MILLSECONDS_IN_SECONDS = 1000;

    public RowTypeSGDSCHEDULE extract(ResultSet rs) throws SQLException, DatatypeConfigurationException {
        RowTypeSGDSCHEDULE rowSchedule = new RowTypeSGDSCHEDULE();
        rowSchedule.setSTATIONNUM(rs.getString("STATION_ID"));
        rowSchedule.setDATABASEKEY(rs.getString("PROGRAM_ID"));
        rowSchedule.setLANGUAGE(rs.getString("SCHEDULE_LANGUAGE"));
        rowSchedule.setAIRDATE(XMLGregorianCalendarUtil.getXMLDate((Timestamp)rs.getTimestamp("START_TIME")));
        rowSchedule.setDURATION(TimeUtil.getDuration((long)(rs.getLong("DURATION") * 1000L)));
        rowSchedule.setPARTNUM(rs.getBigDecimal("PART_NUMBER"));
        rowSchedule.setNUMOFPARTS(rs.getBigDecimal("NO_OF_PARTS"));
        rowSchedule.setCC(rs.getString("CC"));
        rowSchedule.setSTEREO(rs.getString("STEREO"));
        rowSchedule.setREPEAT(rs.getString("REPEAT"));
        rowSchedule.setLIVETAPEDELAY(rs.getString("LIVE_TAPE_DELAY"));
        rowSchedule.setSUBTITLED(rs.getString("SUBTITLED"));
        rowSchedule.setPREMIEREFINALE(rs.getString("PREMIERE_FINALE"));
        rowSchedule.setJOINEDINPROGRESS(rs.getString("JOINED_IN_PROGRESS"));
        rowSchedule.setCABLEINTHECLASSROOM(rs.getString("CABLE_IN_CLASSROOM"));
        rowSchedule.setTVRATING(rs.getString("TV_RATING"));
        rowSchedule.setSAP(rs.getString("SAP"));
        rowSchedule.setBLACKOUT(rs.getString("BLACKOUT"));
        rowSchedule.setSEXRATING(rs.getString("SEX_RATING"));
        rowSchedule.setVIOLENCERATING(rs.getString("VIOLENCE_RATING"));
        rowSchedule.setLANGUAGERATING(rs.getString("LANGUAGE_RATING"));
        rowSchedule.setDIALOGRATING(rs.getString("DIALOG_RATING"));
        rowSchedule.setFVRATING(rs.getString("FV_RATING"));
        rowSchedule.setENHANCED(rs.getString("ENHANCED"));
        rowSchedule.setTHREED(rs.getString("THREE_D"));
        rowSchedule.setLETTERBOX(rs.getString("LETTERBOX"));
        rowSchedule.setHDTV(rs.getString("HD_TV"));
        rowSchedule.setDOLBY(rs.getString("DOLBY"));
        rowSchedule.setDVS(rs.getString("DVS"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA1"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA2"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA3"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA4"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA5"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA6"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA7"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA8"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA9"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA10"));
        rowSchedule.getUSERDATA().add(rs.getString("USER_DATA11"));
        rowSchedule.setREQUESTRECORD(rs.getString("REQUEST_RECORD"));
        String seriesId = rs.getString("SERIES_ID");
        if (!StringUtils.isBlank((String)seriesId)) {
            SeriesInformation seriesInformation = new SeriesInformation();
            seriesInformation.setSeriesIdentifier(seriesId);
            rowSchedule.setSERIESLINK(seriesInformation);
        }
        return rowSchedule;
    }
}

