/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.EtvFormatUtil;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.ExceptionHandler;
import com.ericsson.cms.epgmgmt.export.worker.consumer.GuideDataConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.ConsumerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.future.ExportResult;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.GuideDataProducer;
import com.ericsson.cms.epgmgmt.utility.io.InputStreamEnumerator;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;
import java.beans.ExceptionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataExporter {
    private static final Log logger = LogFactory.getLog(GuideDataExporter.class);
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue = new ArrayBlockingQueue<RowTypeSGDHEADEND>(1000);
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue = new ArrayBlockingQueue<RowTypeSGDLINEUP>(2000);
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue = new ArrayBlockingQueue<RowTypeSGDSTATION>(2000);
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue = new ArrayBlockingQueue<RowTypeSGDSCHEDULE>(500000);
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue = new ArrayBlockingQueue<RowTypeSGDPROGRAM>(1000000);
    private final ExportETVTypeEnum etvFormat;
    private final String tempFolder;
    private final DataSource datasource;
    private ExecutorService geExecutor;
    private GuideDataProducer guideDataProducer;
    private GuideDataConsumer guideDataConsumer;
    private final Map<ExportETVTypeEnum, String> stgGuideHeaderMap;
    private final long publisherId;

    public GuideDataExporter(ExportETVTypeEnum etvFormat, String tempFolder, DataSource datasource, long publisherId) {
        this.etvFormat = etvFormat;
        this.datasource = datasource;
        this.tempFolder = tempFolder;
        this.publisherId = publisherId;
        this.stgGuideHeaderMap = new HashMap<ExportETVTypeEnum, String>();
        this.stgGuideHeaderMap.put(ExportETVTypeEnum.ETV_18, ".xsd\" Spec_Version=\"1.8\"");
        this.stgGuideHeaderMap.put(ExportETVTypeEnum.ETV_20, ".xsd\" Spec_Version=\"2.0\"");
        this.stgGuideHeaderMap.put(ExportETVTypeEnum.ETV_MIX, "_MIX.xsd\" Spec_Version=\"3.0\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        logger.debug((Object)"execute() - start");
        this.geExecutor = Executors.newFixedThreadPool(2);
        try {
            ExecutorCompletionService<ExportResult> geService = new ExecutorCompletionService<ExportResult>(this.geExecutor);
            this.guideDataProducer = new GuideDataProducer(this.headendQueue, this.lineupQueue, this.stationQueue, this.scheduleQueue, this.programQueue, this.etvFormat, this.datasource, this.publisherId);
            this.guideDataConsumer = new GuideDataConsumer(this.headendQueue, this.lineupQueue, this.stationQueue, this.scheduleQueue, this.programQueue, this.etvFormat, this.tempFolder);
            geService.submit(this.guideDataProducer);
            geService.submit(this.guideDataConsumer);
            this.waitTaskDone(geService);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            if (!this.geExecutor.isShutdown()) {
                this.geExecutor.shutdown();
            }
        }
        logger.debug((Object)"execute() - end");
    }

    private void waitTaskDone(CompletionService<ExportResult> geService) throws InterruptedException, ExecutionException, IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        for (int i = 0; i < 2; ++i) {
            Future<ExportResult> geResult = geService.take();
            if (geResult.get() instanceof ProducerExportResult) {
                logger.debug((Object)String.format("%s - Guide Data Producer done with its tasks (took %s).", PluginLogComponent.EXPORT_TO_XML, TimeUtil.getTimeTook((long)watch.getTime())));
                watch.reset();
                watch.start();
            }
            if (!(geResult.get() instanceof ConsumerExportResult)) continue;
            this.mergeGuideData();
            logger.debug((Object)String.format("%s - Guide Data Consumer done with its tasks (took %s).", PluginLogComponent.EXPORT_TO_XML, TimeUtil.getTimeTook((long)watch.getTime())));
            watch.reset();
            watch.start();
            break;
        }
        watch.stop();
    }

    private void handleException(Exception ex) {
        if (ExceptionUtils.getRootCause((Throwable)ex) instanceof InterruptedException) {
            logger.warn((Object)("execute()- " + PluginLogComponent.EXPORT_TO_XML.toString() + " was interrupted"));
        } else {
            logger.error((Object)("execute()- " + PluginLogComponent.EXPORT_TO_XML.toString()), (Throwable)ex);
        }
        throw ExportToXMLException.wrapper((String)ex.getMessage(), (Exception)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeGuideData() throws IOException {
        logger.debug((Object)"mergeGuideData() - start");
        InputStream gdInputFile = null;
        FileOutputStream gdOutputFile = null;
        try {
            gdOutputFile = new FileOutputStream(this.getTempFile("GuideDataOut.xml"));
            this.fillHeader(gdOutputFile);
            gdInputFile = this.getInputGuideFile();
            IOUtils.copy((InputStream)gdInputFile, (OutputStream)gdOutputFile);
            ((OutputStream)gdOutputFile).write("</SlicerGuideData>\n</GuideData>".getBytes());
            this.deleteTempInputGuideFile();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(gdInputFile);
            IOUtils.closeQuietly(gdOutputFile);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)gdInputFile);
        IOUtils.closeQuietly((OutputStream)gdOutputFile);
        logger.debug((Object)"mergeGuideData() - end");
    }

    private void fillHeader(OutputStream gdOutputFile) throws IOException {
        gdOutputFile.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
        gdOutputFile.write("<GuideData xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\" xmlns:xdt=\"http://www.w3.org/2005/xpath-datatypes\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"ETV_EPG".getBytes());
        gdOutputFile.write(this.stgGuideHeaderMap.get((Object)this.etvFormat).getBytes());
        gdOutputFile.write(">\n<SlicerGuideData>\n".getBytes());
    }

    private InputStream getInputGuideFile() {
        InputStreamEnumerator ipSteamEnum = new InputStreamEnumerator(this.getInputGideFileList(), (ExceptionListener)new ExceptionHandler());
        return new SequenceInputStream((Enumeration<? extends InputStream>)ipSteamEnum);
    }

    private List<String> getInputGideFileList() {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getTempFile("rowHeadEnd.xml"));
        files.add(this.getTempFile("rowLineup.xml"));
        files.add(this.getTempFile("rowStation.xml"));
        if (!EtvFormatUtil.isETVMIX(this.etvFormat)) {
            files.add(this.getTempFile("rowSchedule.xml"));
        }
        files.add(this.getTempFile("rowProgram.xml"));
        return files;
    }

    private void deleteTempInputGuideFile() {
        for (String filename : this.getInputGideFileList()) {
            FileUtils.deleteQuietly((File)new File(filename));
        }
    }

    private String getTempFile(String tempFile) {
        return this.tempFolder + System.getProperty("file.separator") + tempFile;
    }

    public void shutdown() {
        if (this.guideDataProducer != null) {
            this.guideDataProducer.shutdownNow();
        }
        if (this.guideDataConsumer != null) {
            this.guideDataConsumer.shutdownNow();
        }
        if (this.geExecutor == null || this.geExecutor.isShutdown()) {
            return;
        }
        this.geExecutor.shutdown();
    }
}

