/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.EtvFormatUtil;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.consumer.HeadendConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.LineupConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.ProgramConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.ScheduleConsumer;
import com.ericsson.cms.epgmgmt.export.worker.consumer.StationConsumer;
import com.ericsson.cms.epgmgmt.export.worker.future.ConsumerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.future.ExportResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataConsumer
implements Callable<ExportResult> {
    private static final Log LOGGER = LogFactory.getLog(GuideDataConsumer.class);
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final ExportETVTypeEnum etvFormat;
    private final String tempFolder;
    private ThreadPoolExecutor consumerThreadPool;
    private final ConsumerExportResult result = new ConsumerExportResult(false);

    public GuideDataConsumer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, BlockingQueue<RowTypeSGDLINEUP> lineupQueue, BlockingQueue<RowTypeSGDSTATION> stationQueue, BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, BlockingQueue<RowTypeSGDPROGRAM> programQueue, ExportETVTypeEnum etvFormat, String tempFolder) {
        this.headendQueue = headendQueue;
        this.lineupQueue = lineupQueue;
        this.stationQueue = stationQueue;
        this.scheduleQueue = scheduleQueue;
        this.programQueue = programQueue;
        this.etvFormat = etvFormat;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportResult call() throws ExportToXMLException {
        this.consumerThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);
        this.consumerThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        try {
            ArrayList<Callable<ConsumerExportResult>> consumerTasks = new ArrayList<Callable<ConsumerExportResult>>();
            consumerTasks.add(new HeadendConsumer(this.headendQueue, this.tempFolder));
            consumerTasks.add(new LineupConsumer(this.lineupQueue, this.tempFolder));
            consumerTasks.add(new StationConsumer(this.stationQueue, this.tempFolder));
            if (!EtvFormatUtil.isETVMIX(this.etvFormat)) {
                consumerTasks.add(new ScheduleConsumer(this.scheduleQueue, this.tempFolder));
            }
            consumerTasks.add(new ProgramConsumer(this.programQueue, this.tempFolder));
            if (this.consumerThreadPool.isShutdown()) {
                this.result.setResult(false);
                ConsumerExportResult consumerExportResult = this.result;
                return consumerExportResult;
            }
            List consumerResults = this.consumerThreadPool.invokeAll(consumerTasks);
            for (Future future : consumerResults) {
                ConsumerExportResult taskResult = (ConsumerExportResult)future.get();
                LOGGER.debug((Object)String.format("%s - Is all records produced by %s producer are processed? %s", PluginLogComponent.EXPORT_TO_XML, taskResult.getConsumerName(), taskResult.isResult()));
            }
            this.result.setResult(true);
        }
        catch (Exception ex) {
            this.result.handleException(ex);
        }
        finally {
            this.consumerThreadPool.shutdown();
        }
        return this.result;
    }

    public void shutdownNow() {
        if (this.consumerThreadPool == null || this.consumerThreadPool.isShutdown()) {
            LOGGER.debug((Object)"GuideDataConsumer:shutdown() - consumerExecutor has already been shut down.");
            return;
        }
        this.consumerThreadPool.shutdownNow();
    }
}

