/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.worker.future.ConsumerExportResult;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class LineupConsumer
implements Callable<ConsumerExportResult> {
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller lineupMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public LineupConsumer(BlockingQueue<RowTypeSGDLINEUP> lineupQueue, String tempFolder) {
        this.lineupQueue = lineupQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerExportResult call() throws InterruptedException {
        ConsumerExportResult result = new ConsumerExportResult("Lineup", false);
        boolean amIDone = false;
        FileOutputStream lineupFile = null;
        BufferedWriter lineupOut = null;
        try {
            lineupFile = new FileOutputStream(this.tempFolder + System.getProperty("file.separator") + "rowLineup.xml");
            lineupOut = new BufferedWriter(new OutputStreamWriter((OutputStream)lineupFile, "UTF-8"));
            lineupOut.write("<LINEUP>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDLINEUP rowLineup = this.lineupQueue.take();
                if (rowLineup.getCLROWID() != null && rowLineup.getCLROWID().longValue() == -1L) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowLineup, (Writer)sw);
                String lineupRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                lineupOut.write(lineupRow);
            }
            lineupOut.write("</LINEUP>\n");
            result.setResult(true);
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        finally {
            try {
                if (lineupOut != null) {
                    lineupOut.close();
                }
                if (lineupFile != null) {
                    lineupFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() {
        String exMsg = "Lineup - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (lineupMarshler == null) {
                lineupMarshler = jcEtv.createMarshaller();
                lineupMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                lineupMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return lineupMarshler;
    }
}

