/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.worker.future.ConsumerExportResult;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ScheduleConsumer
implements Callable<ConsumerExportResult> {
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller scheduleMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public ScheduleConsumer(BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, String tempFolder) {
        this.scheduleQueue = scheduleQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerExportResult call() throws InterruptedException {
        ConsumerExportResult result = new ConsumerExportResult("Schedule", false);
        boolean amIDone = false;
        FileOutputStream scheduleFile = null;
        BufferedWriter scheduleOut = null;
        try {
            scheduleFile = new FileOutputStream(this.tempFolder + System.getProperty("file.separator") + "rowSchedule.xml");
            scheduleOut = new BufferedWriter(new OutputStreamWriter((OutputStream)scheduleFile, "UTF-8"));
            scheduleOut.write("<SCHEDULE>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDSCHEDULE rowSchedule = this.scheduleQueue.take();
                if (rowSchedule.getDATABASEKEY() != null && rowSchedule.getDATABASEKEY().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowSchedule, (Writer)sw);
                String scheduleRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                scheduleOut.write(scheduleRow);
            }
            scheduleOut.write("</SCHEDULE>\n");
            result.setResult(true);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        finally {
            try {
                if (scheduleOut != null) {
                    scheduleOut.close();
                }
                if (scheduleFile != null) {
                    scheduleFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() {
        String exMsg = "Schedule - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (scheduleMarshler == null) {
                scheduleMarshler = jcEtv.createMarshaller();
                scheduleMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                scheduleMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return scheduleMarshler;
    }
}

