/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.consumer;

import com.ericsson.cms.epgmgmt.exception.ExportToXMLException;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.ConsumerExportResult;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class StationConsumer
implements Callable<ConsumerExportResult> {
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final String tempFolder;
    private static JAXBContext jcEtv = null;
    private static Marshaller stationMarshler = null;
    private static final String etvBoRepository = "com.ericsson.cms.epgmgmt.export.bo";

    public StationConsumer(BlockingQueue<RowTypeSGDSTATION> stationQueue, String tempFolder) {
        this.stationQueue = stationQueue;
        this.tempFolder = tempFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerExportResult call() throws InterruptedException {
        ConsumerExportResult result = new ConsumerExportResult("Station", false);
        boolean amIDone = false;
        FileOutputStream stationFile = null;
        BufferedWriter stationOut = null;
        try {
            stationFile = new FileOutputStream(this.tempFolder + System.getProperty("file.separator") + "rowStation.xml");
            stationOut = new BufferedWriter(new OutputStreamWriter((OutputStream)stationFile, "UTF-8"));
            stationOut.write("<STATION>\n");
            while (!amIDone && !Thread.currentThread().isInterrupted()) {
                RowTypeSGDSTATION rowStation = this.stationQueue.take();
                if (rowStation.getSTATIONNUM() != null && rowStation.getSTATIONNUM().equalsIgnoreCase("done")) {
                    amIDone = true;
                    continue;
                }
                StringWriter sw = new StringWriter();
                this.getETVMarshler().marshal((Object)rowStation, (Writer)sw);
                String stationRow = sw.toString().substring(sw.toString().indexOf("<row>"));
                stationOut.write(stationRow);
            }
            stationOut.write("</STATION>\n");
            result.setResult(true);
        }
        catch (IOException ex) {
            result.handleException(ex);
        }
        catch (JAXBException ex) {
            result.handleException((Exception)((Object)ex));
        }
        finally {
            try {
                if (stationOut != null) {
                    stationOut.close();
                }
                if (stationFile != null) {
                    stationFile.close();
                }
            }
            catch (IOException ex) {
                result.handleException(ex);
            }
        }
        return result;
    }

    private Marshaller getETVMarshler() {
        String exMsg = "Station - Error found while creating Marsheler for ETV";
        try {
            if (jcEtv == null) {
                jcEtv = JAXBContext.newInstance((String)etvBoRepository);
            }
            if (stationMarshler == null) {
                stationMarshler = jcEtv.createMarshaller();
                stationMarshler.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                stationMarshler.setProperty("jaxb.encoding", (Object)"UTF-8");
            }
        }
        catch (JAXBException jEx) {
            throw new ExportToXMLException(exMsg, (Throwable)jEx);
        }
        return stationMarshler;
    }
}

