/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.future;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.export.worker.future.ExportResult;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;

public class ProducerExportResult
extends ExportResult {
    private final IAlarmActivityLogManager applicationLogger;
    private final String producerName;
    private long publisherId;
    private final long startTime = System.currentTimeMillis();

    public ProducerExportResult(boolean result) {
        this("", result);
    }

    public ProducerExportResult(String producerName, boolean result) {
        super(result);
        this.producerName = producerName;
        this.applicationLogger = (IAlarmActivityLogManager)ApplicationContextUtil.getBean((String)"alarmActivityLogManager", IAlarmActivityLogManager.class);
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void handleException(Exception ex) {
        super.handleException(ex, "Producer", this.producerName);
    }

    public long getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(long publisherId) {
        this.publisherId = publisherId;
    }

    public void logResult(long count) {
        String title;
        EmailAlertLevelEnum messageLevel;
        PluginLogSeverity logSeverity;
        if (count == 0L) {
            logSeverity = PluginLogSeverity.WARNING;
            messageLevel = EmailAlertLevelEnum.WARNING;
            title = "No";
        } else {
            logSeverity = PluginLogSeverity.INFORMATION;
            messageLevel = EmailAlertLevelEnum.INFO;
            title = String.valueOf(count);
        }
        String msg = String.format("%s %s filtered out of epg receiver data for epg receiver in %s", title, this.producerName, TimeUtil.getTimeTook((long)(System.currentTimeMillis() - this.startTime)));
        this.applicationLogger.log(logSeverity, PluginLogComponent.EXPORT_TO_XML, msg, this.getPublisherId(), PartnerTypeEnum.Receiver.toString());
        MessageEntryUtil.addMessage(new MessageEntry(messageLevel, "", msg, PluginLogComponent.EXPORT_TO_XML));
    }
}

