/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.export.EtvFormatUtil;
import com.ericsson.cms.epgmgmt.export.ExportETVTypeEnum;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.ExportResult;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.HeadendProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.LineupProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.ProgramProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.ScheduleProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.StationProducer;
import com.ericsson.cms.epgmgmt.utility.time.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.sql.DataSource;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuideDataProducer
implements Callable<ExportResult> {
    private static final Log LOGGER = LogFactory.getLog(GuideDataProducer.class);
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final ExportETVTypeEnum etvFormat;
    private final DataSource datasource;
    private final long publisherId;
    private ThreadPoolExecutor producerThreadPool;
    private final ProducerExportResult result = new ProducerExportResult(false);

    public GuideDataProducer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, BlockingQueue<RowTypeSGDLINEUP> lineupQueue, BlockingQueue<RowTypeSGDSTATION> stationQueue, BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, BlockingQueue<RowTypeSGDPROGRAM> programQueue, ExportETVTypeEnum etvFormat, DataSource datasource, long publisherId) {
        this.headendQueue = headendQueue;
        this.lineupQueue = lineupQueue;
        this.stationQueue = stationQueue;
        this.scheduleQueue = scheduleQueue;
        this.programQueue = programQueue;
        this.etvFormat = etvFormat;
        this.datasource = datasource;
        this.publisherId = publisherId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportResult call() throws InterruptedException, ExecutionException {
        this.producerThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);
        this.producerThreadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        try {
            Collection<Callable<ProducerExportResult>> producerTasks = this.getProducerTasks();
            this.result.setResult(this.runProducerTasks(producerTasks));
        }
        finally {
            this.producerThreadPool.shutdown();
        }
        return this.result;
    }

    private Collection<Callable<ProducerExportResult>> getProducerTasks() {
        ArrayList<Callable<ProducerExportResult>> producerTasks = new ArrayList<Callable<ProducerExportResult>>();
        producerTasks.add(new HeadendProducer(this.headendQueue, EtvFormatUtil.isETV20(this.etvFormat) || EtvFormatUtil.isETVMIX(this.etvFormat), this.datasource, this.publisherId));
        producerTasks.add(new LineupProducer(this.lineupQueue, EtvFormatUtil.isETV18(this.etvFormat), this.datasource, this.publisherId));
        producerTasks.add(new StationProducer(this.stationQueue, EtvFormatUtil.isETV20(this.etvFormat) || EtvFormatUtil.isETVMIX(this.etvFormat), this.datasource, this.publisherId));
        ScheduleProducer scheduleProducer = new ScheduleProducer(this.scheduleQueue, this.datasource, this.publisherId);
        if (!EtvFormatUtil.isETVMIX(this.etvFormat)) {
            producerTasks.add(scheduleProducer);
        }
        producerTasks.add(new ProgramProducer(this.programQueue, EtvFormatUtil.isETVMIX(this.etvFormat), this.datasource, scheduleProducer));
        return producerTasks;
    }

    private boolean runProducerTasks(Collection<Callable<ProducerExportResult>> producerTasks) throws InterruptedException, ExecutionException {
        StopWatch watch = new StopWatch();
        watch.start();
        if (this.producerThreadPool.isShutdown()) {
            return false;
        }
        List<Future<ProducerExportResult>> producerResults = this.producerThreadPool.invokeAll(producerTasks);
        for (Future<ProducerExportResult> future : producerResults) {
            ProducerExportResult taskResult = future.get();
            LOGGER.debug((Object)String.format("%s - Is all %s filtered out of published data for publisher? %s", PluginLogComponent.EXPORT_TO_XML, taskResult.getProducerName(), taskResult.isResult()));
        }
        LOGGER.info((Object)String.format("GuideDataProducer cost: %s", TimeUtil.getTimeTook((long)watch.getTime())));
        watch.stop();
        return true;
    }

    public void shutdownNow() {
        if (this.producerThreadPool == null || this.producerThreadPool.isShutdown()) {
            LOGGER.debug((Object)"GuideDataProducer:shutdown() - producerExecutor has already been shut down.");
            return;
        }
        this.producerThreadPool.shutdownNow();
    }
}

