/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDHEADEND;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.dataloader.HeadendLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class HeadendProducer
implements Callable<ProducerExportResult> {
    private final BlockingQueue<RowTypeSGDHEADEND> headendQueue;
    private final boolean isHeGenericSupported;
    private final ProducerExportResult geProducer = new ProducerExportResult("headend", false);
    private final HeadendLoader headendLoader;
    private OrderListValueMap<RowTypeSGDHEADEND> headends;
    private OrderListValueMap<GenericType> generic;

    public HeadendProducer(BlockingQueue<RowTypeSGDHEADEND> headendQueue, boolean isHeGenericSupported, DataSource dataSource, long publisherId) {
        this.headendQueue = headendQueue;
        this.isHeGenericSupported = isHeGenericSupported;
        this.headendLoader = new HeadendLoader(dataSource);
        this.geProducer.setPublisherId(publisherId);
    }

    private void load() {
        this.headendLoader.load();
        this.headends = this.headendLoader.getHeadends();
        this.generic = this.headendLoader.getGenerics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerExportResult call() {
        this.load();
        try {
            for (RowTypeSGDHEADEND headend : this.headends.getList()) {
                String headendId = headend.getHEHEADENDID();
                if (this.isHeGenericSupported) {
                    String headendIdKey = CombinedKeyUtil.getCombinedKey((String)headendId);
                    this.generic.drainTo(headendIdKey, headend.getHEGENERIC());
                }
                this.headendQueue.put(headend);
            }
            this.geProducer.setResult(true);
            this.geProducer.logResult(this.headends.size());
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
        finally {
            this.putLastRecord();
        }
        return this.geProducer;
    }

    private void putLastRecord() {
        RowTypeSGDHEADEND rowHeadend = new RowTypeSGDHEADEND();
        rowHeadend.setHEHEADENDID("done");
        try {
            this.headendQueue.put(rowHeadend);
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
    }
}

