/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.dataloader.LineupLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.math.BigDecimal;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class LineupProducer
implements Callable<ProducerExportResult> {
    private final BlockingQueue<RowTypeSGDLINEUP> lineupQueue;
    private final boolean isEtv18;
    private final LineupLoader lineupLoader;
    private final ProducerExportResult geProducer = new ProducerExportResult("lineup", false);
    private OrderListValueMap<RowTypeSGDLINEUP> lineups;
    private OrderListValueMap<GenericType> generics;

    public LineupProducer(BlockingQueue<RowTypeSGDLINEUP> lineupQueue, boolean isEtv18, DataSource dataSource, long publisherId) {
        this.lineupQueue = lineupQueue;
        this.isEtv18 = isEtv18;
        this.lineupLoader = new LineupLoader(dataSource, isEtv18);
        this.geProducer.setPublisherId(publisherId);
    }

    private void load() {
        this.lineupLoader.load();
        this.lineups = this.lineupLoader.getLineups();
        this.generics = this.lineupLoader.getGenerics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerExportResult call() {
        try {
            this.load();
            this.fillLineup();
            this.geProducer.setResult(true);
            this.geProducer.logResult(this.lineups.size());
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
        finally {
            this.putLastRecord();
        }
        return this.geProducer;
    }

    private void fillLineup() throws InterruptedException {
        for (RowTypeSGDLINEUP lineup : this.lineups.getList()) {
            if (!this.isEtv18) {
                this.fillExtra(lineup);
            }
            this.lineupQueue.put(lineup);
        }
    }

    private void fillExtra(RowTypeSGDLINEUP lineup) {
        String lineupId = lineup.getCLROWID().toString();
        String headendId = lineup.getCLHEADENDID();
        String stationId = lineup.getCLSTATIONNUM();
        String key = CombinedKeyUtil.getCombinedKey((String[])new String[]{lineupId, headendId, stationId});
        this.generics.drainTo(key, lineup.getCLGENERIC());
    }

    private void putLastRecord() {
        RowTypeSGDLINEUP rowLineup = new RowTypeSGDLINEUP();
        rowLineup.setCLROWID(BigDecimal.valueOf(-1L));
        try {
            this.lineupQueue.put(rowLineup);
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
    }
}

