/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.AudioComponentType;
import com.ericsson.cms.epgmgmt.export.bo.CASTNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.CREDITSNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.ComponentAttribute;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RatingType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.SubtitleComponentType;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.ScheduleProducer;
import com.ericsson.cms.epgmgmt.export.worker.producer.dataloader.ProgramLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class ProgramProducer
implements Callable<ProducerExportResult> {
    private final BlockingQueue<RowTypeSGDPROGRAM> programQueue;
    private final boolean isEtvMix;
    private final ScheduleProducer scheduleProducer;
    private ProducerExportResult geProducer;
    private OrderListValueMap<RowTypeSGDPROGRAM> programs;
    private OrderListValueMap<GenericType> generics;
    private OrderListValueMap<CASTNAMEROLEType> casts;
    private OrderListValueMap<CREDITSNAMEROLEType> credits;
    private OrderListValueMap<RatingType> ratings;
    private OrderListValueMap<ComponentAttribute> audioComponentAttributes;
    private OrderListValueMap<AudioComponentType> audioComponentTypes;
    private OrderListValueMap<ComponentAttribute> subtitleComponentAttributes;
    private OrderListValueMap<SubtitleComponentType> subtitleComponentTypes;
    private final ProgramLoader programLoader;

    public ProgramProducer(BlockingQueue<RowTypeSGDPROGRAM> programQueue, boolean isEtvMix, DataSource dataSource, ScheduleProducer scheduleProducer) {
        this.programQueue = programQueue;
        this.isEtvMix = isEtvMix;
        this.scheduleProducer = scheduleProducer;
        this.programLoader = new ProgramLoader(dataSource);
    }

    private void load() {
        this.programLoader.load();
        this.programs = this.programLoader.getPrograms();
        this.generics = this.programLoader.getGenerics();
        this.casts = this.programLoader.getCasts();
        this.credits = this.programLoader.getCredits();
        this.ratings = this.programLoader.getRatings();
        this.audioComponentAttributes = this.programLoader.getAudioComponentAttributes();
        this.audioComponentTypes = this.programLoader.getAudioComponentTypes();
        this.subtitleComponentAttributes = this.programLoader.getSubtitleComponentAttributes();
        this.subtitleComponentTypes = this.programLoader.getSubtitleComponentTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerExportResult call() {
        try {
            this.load();
            this.geProducer = new ProducerExportResult("Program", false);
            this.geProducer.setPublisherId(this.scheduleProducer.getPublisherId());
            this.queuePrograms();
            this.geProducer.setResult(true);
            this.geProducer.logResult(this.programs.size());
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
        finally {
            this.putLastRecord();
        }
        return this.geProducer;
    }

    private void queuePrograms() throws InterruptedException {
        for (RowTypeSGDPROGRAM program : this.programs.getList()) {
            this.programQueue.put(this.fillRowProgram(program));
        }
    }

    private RowTypeSGDPROGRAM fillRowProgram(RowTypeSGDPROGRAM program) {
        String programId = program.getDATABASEKEY();
        String programIdKey = CombinedKeyUtil.getCombinedKey((String)programId);
        this.generics.drainTo(programIdKey, program.getPROGRAMGENERIC());
        this.casts.drainTo(programIdKey, program.getCASTNAMEROLE());
        this.credits.drainTo(programIdKey, program.getCREDITSNAMEROLE());
        this.ratings.drainTo(programIdKey, program.getPROGRAMRATING());
        if (this.audioComponentTypes.containsKey(programIdKey)) {
            List<AudioComponentType> audioComponents = this.fillAudioComponent(programId, programIdKey);
            program.getAUDIOCOMPONENT().addAll(audioComponents);
        }
        if (this.subtitleComponentTypes.containsKey(programIdKey)) {
            List<SubtitleComponentType> subtitleComponents = this.fillSubtitleComponents(programId, programIdKey);
            program.getSUBTITLECOMPONENT().addAll(subtitleComponents);
        }
        if (this.isEtvMix) {
            program.setSCHEDULE(this.scheduleProducer.getSchedulesAssoicatedWithProgram(programId));
        }
        return program;
    }

    private List<SubtitleComponentType> fillSubtitleComponents(String programId, String programIdKey) {
        List subtitleComponents = this.subtitleComponentTypes.getValues(programIdKey);
        for (SubtitleComponentType subtitleComponentType : subtitleComponents) {
            String type = subtitleComponentType.getType();
            String language = subtitleComponentType.getLanguage();
            String key = CombinedKeyUtil.getCombinedKey((String[])new String[]{programId, type, language});
            this.subtitleComponentAttributes.drainTo(key, subtitleComponentType.getComponentAttribute());
        }
        return subtitleComponents;
    }

    private List<AudioComponentType> fillAudioComponent(String programId, String programIdKey) {
        List audioComponents = this.audioComponentTypes.getValues(programIdKey);
        for (AudioComponentType audioComponentType : audioComponents) {
            String type = audioComponentType.getType();
            String language = audioComponentType.getLanguage();
            String key = CombinedKeyUtil.getCombinedKey((String[])new String[]{programId, type, language});
            this.audioComponentAttributes.drainTo(key, audioComponentType.getComponentAttribute());
        }
        return audioComponents;
    }

    private void putLastRecord() {
        try {
            RowTypeSGDPROGRAM rowProgram = new RowTypeSGDPROGRAM();
            rowProgram.setDATABASEKEY("done");
            this.programQueue.put(rowProgram);
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
    }
}

