/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.EventIdType;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.SeriesAttributeType;
import com.ericsson.cms.epgmgmt.export.bo.SeriesInformation;
import com.ericsson.cms.epgmgmt.export.bo.TableTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.dataloader.ScheduleLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class ScheduleProducer
implements Callable<ProducerExportResult> {
    private final BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue;
    private ProducerExportResult geProducer = null;
    private final ScheduleLoader scheduleLoader;
    private OrderListValueMap<RowTypeSGDSCHEDULE> schedules;
    private OrderListValueMap<GenericType> generics;
    private OrderListValueMap<EventIdType> eventIds;
    private OrderListValueMap<SeriesAttributeType> seriesAttibutes;
    private boolean isLoaded = false;
    private long publisherId;

    public ScheduleProducer(BlockingQueue<RowTypeSGDSCHEDULE> scheduleQueue, DataSource dataSource, long publisherId) {
        this.scheduleQueue = scheduleQueue;
        this.scheduleLoader = new ScheduleLoader(dataSource);
        this.publisherId = publisherId;
    }

    private synchronized void load() {
        if (this.isLoaded) {
            return;
        }
        this.scheduleLoader.load();
        this.schedules = this.scheduleLoader.getSchedules();
        this.generics = this.scheduleLoader.getGenerics();
        this.eventIds = this.scheduleLoader.getEventIds();
        this.seriesAttibutes = this.scheduleLoader.getSeriesAttibute();
        this.isLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerExportResult call() {
        try {
            this.geProducer = new ProducerExportResult("Schedule", false);
            this.geProducer.setPublisherId(this.getPublisherId());
            this.load();
            this.queueSchedules();
            this.geProducer.setResult(true);
            this.geProducer.logResult(this.schedules.size());
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
        finally {
            this.putLastRecord();
        }
        return this.geProducer;
    }

    private void queueSchedules() throws InterruptedException {
        List scheduleList = this.schedules.getList();
        for (RowTypeSGDSCHEDULE schedule : scheduleList) {
            this.fillExtraFields(schedule);
            this.scheduleQueue.put(schedule);
        }
    }

    public TableTypeSGDSCHEDULE getSchedulesAssoicatedWithProgram(String programId) {
        this.load();
        TableTypeSGDSCHEDULE schedulesResult = new TableTypeSGDSCHEDULE();
        String programIDKey = CombinedKeyUtil.getCombinedKey((String)programId);
        if (this.schedules.containsKey(programIDKey)) {
            List rowSchedules = this.schedules.getValues(programIDKey);
            for (RowTypeSGDSCHEDULE rowSchedule : rowSchedules) {
                this.fillExtraFields(rowSchedule);
                schedulesResult.getRow().add(rowSchedule);
            }
        }
        return schedulesResult;
    }

    private void fillExtraFields(RowTypeSGDSCHEDULE rowSchedule) {
        String programId = rowSchedule.getDATABASEKEY();
        String programIDKey = CombinedKeyUtil.getCombinedKey((String)programId);
        this.generics.drainTo(programIDKey, rowSchedule.getSCHEDULEGENERIC());
        this.eventIds.drainTo(programIDKey, rowSchedule.getEVENTID());
        if (this.seriesAttibutes.containsKey(programIDKey)) {
            this.fillSeriesLink(rowSchedule, programIDKey);
        }
    }

    private void fillSeriesLink(RowTypeSGDSCHEDULE rowSchedule, String programIDKey) {
        SeriesInformation seriesInformation = rowSchedule.getSERIESLINK();
        if (seriesInformation == null) {
            return;
        }
        for (SeriesAttributeType seriesAttibute : this.seriesAttibutes.getValues(programIDKey)) {
            String attibuteType = seriesAttibute.getAttributeType();
            if (attibuteType.equalsIgnoreCase("seriesId")) continue;
            seriesInformation.getSeriesAttribute().add(seriesAttibute);
        }
    }

    private void putLastRecord() {
        try {
            RowTypeSGDSCHEDULE rowSchedule = new RowTypeSGDSCHEDULE();
            rowSchedule.setDATABASEKEY("done");
            this.scheduleQueue.put(rowSchedule);
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
    }

    public long getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(long publisherId) {
        this.publisherId = publisherId;
    }
}

