/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer;

import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.worker.future.ProducerExportResult;
import com.ericsson.cms.epgmgmt.export.worker.producer.dataloader.StationLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class StationProducer
implements Callable<ProducerExportResult> {
    private final BlockingQueue<RowTypeSGDSTATION> stationQueue;
    private final boolean isStationGenericSupported;
    private final ProducerExportResult geProducer = new ProducerExportResult("station", false);
    private final StationLoader stationLoader;
    private OrderListValueMap<RowTypeSGDSTATION> stations;
    private OrderListValueMap<GenericType> generics;

    public StationProducer(BlockingQueue<RowTypeSGDSTATION> stationQueue, boolean isStationGenericSupported, DataSource dataSource, long publisherId) {
        this.stationQueue = stationQueue;
        this.isStationGenericSupported = isStationGenericSupported;
        this.stationLoader = new StationLoader(dataSource, isStationGenericSupported);
        this.geProducer.setPublisherId(publisherId);
    }

    private void load() {
        this.stationLoader.load();
        this.stations = this.stationLoader.getStations();
        this.generics = this.stationLoader.getGenerics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProducerExportResult call() {
        try {
            this.load();
            this.queueStations();
            this.geProducer.setResult(true);
            this.geProducer.logResult(this.stations.size());
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
        finally {
            this.putLastRecord();
        }
        return this.geProducer;
    }

    private void queueStations() throws InterruptedException {
        for (RowTypeSGDSTATION station : this.stations.getList()) {
            if (this.isStationGenericSupported) {
                this.generics.drainTo(CombinedKeyUtil.getCombinedKey((String)station.getSTATIONNUM()), station.getSTATIONGENERIC());
            }
            this.stationQueue.put(station);
        }
    }

    private void putLastRecord() {
        try {
            RowTypeSGDSTATION rowSation = new RowTypeSGDSTATION();
            rowSation.setSTATIONNUM("done");
            this.stationQueue.put(rowSation);
        }
        catch (InterruptedException ex) {
            this.geProducer.handleException(ex);
        }
    }
}

