/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer.dataloader;

import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.GenericTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUP;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDLINEUPExtractor;
import com.ericsson.cms.epgmgmt.export.worker.ExceptionHandler;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.beans.ExceptionListener;
import javax.sql.DataSource;

public class LineupLoader {
    private static final String SQL_LINEUP = "select * from exp_LINEUP order by LINEUP_ID,STATION_ID,HEADEND_ID";
    private static final String SQL_LINEUP_GENERIC = "select * from exp_lineup_generic";
    private final DataLoader dataLoader;
    private OrderListValueMap<RowTypeSGDLINEUP> lineups;
    private OrderListValueMap<GenericType> generics;
    private final boolean isEtv18;
    private final String[] columns = new String[]{"lineup_id", "headend_id", "station_id"};

    public LineupLoader(DataSource dataSource, boolean isEtv18) {
        this.dataLoader = new DataLoader(dataSource, this.columns, (ExceptionListener)new ExceptionHandler());
        this.isEtv18 = isEtv18;
    }

    public void load() {
        if (!this.isEtv18) {
            this.generics = this.dataLoader.load(SQL_LINEUP_GENERIC, (RowExtractor)new GenericTypeExtractor());
        }
        this.lineups = this.dataLoader.load(SQL_LINEUP, (RowExtractor)new RowTypeSGDLINEUPExtractor(this.isEtv18));
    }

    public OrderListValueMap<RowTypeSGDLINEUP> getLineups() {
        return this.lineups;
    }

    public OrderListValueMap<GenericType> getGenerics() {
        return this.generics;
    }
}

