/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer.dataloader;

import com.ericsson.cms.epgmgmt.export.bo.AudioComponentType;
import com.ericsson.cms.epgmgmt.export.bo.AudioComponentTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.CASTNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.CASTNAMEROLETypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.CREDITSNAMEROLEType;
import com.ericsson.cms.epgmgmt.export.bo.CREDITSNAMEROLETypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.ComponentAttribute;
import com.ericsson.cms.epgmgmt.export.bo.ComponentAttributeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.GenericTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.RatingType;
import com.ericsson.cms.epgmgmt.export.bo.RatingTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAM;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDPROGRAMExtractor;
import com.ericsson.cms.epgmgmt.export.bo.SubtitleComponentType;
import com.ericsson.cms.epgmgmt.export.bo.SubtitleComponentTypeExtractor;
import com.ericsson.cms.epgmgmt.export.worker.ExceptionHandler;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.beans.ExceptionListener;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;

public class ProgramLoader {
    private static final String SQL_PROGRAM = "select * from exp_PROGRAM order by program_id";
    private static final String SQL_PROGRAM_GENERIC = "select * from exp_PROGRAM_GENERIC order by Name";
    private static final String SQL_PROGRAM_CAST = "select FIRST_NAME, LAST_NAME, ROLE, SEQ, PROGRAM_ID from exp_PROGRAM_CAST order by SEQ";
    private static final String SQL_PROGRAM_CREDITS = "select FIRST_NAME, LAST_NAME, ROLE, SEQ, PROGRAM_ID from exp_PROGRAM_CREDITS order by SEQ";
    private static final String SQL_PROGRAM_RATING = "select * from exp_PROGRAM_RATING order by Authority";
    private static final String SQL_PROGRAM_AUDIO_TL = "select distinct Type, Language, PROGRAM_ID from exp_PROGRAM_AUDIO_COMP order by Type,Language";
    private static final String SQL_PROGRAM_AUDIO = "select * from exp_PROGRAM_AUDIO_COMP order by Attribute_Type";
    private static final String SQL_PROGRAM_SUBTITLE_TL = "select distinct Type, Language, PROGRAM_ID from exp_PROGRAM_SUBTITLE_COMP order by Type,Language";
    private static final String SQL_PROGRAM_SUBTITLE = "select * from exp_PROGRAM_SUBTITLE_COMP order by Attribute_Type";
    private final String[] columns = new String[]{"PROGRAM_ID"};
    private final String[] columnsTypeLanguange = new String[]{"TYPE", "LANGUAGE"};
    private final String[] columnsProgramIdTypeLanguange = (String[])ArrayUtils.addAll((Object[])this.columns, (Object[])this.columnsTypeLanguange);
    private final DataLoader dataLoader;
    private OrderListValueMap<RowTypeSGDPROGRAM> programs;
    private OrderListValueMap<GenericType> generics;
    private OrderListValueMap<CASTNAMEROLEType> casts;
    private OrderListValueMap<CREDITSNAMEROLEType> credits;
    private OrderListValueMap<RatingType> ratings;
    private OrderListValueMap<ComponentAttribute> audioComponentAttributes;
    private OrderListValueMap<AudioComponentType> audioComponentTypes;
    private OrderListValueMap<ComponentAttribute> subtitleComponentAttributes;
    private OrderListValueMap<SubtitleComponentType> subtitleComponentTypes;

    public ProgramLoader(DataSource dataSource) {
        this.dataLoader = new DataLoader(dataSource, this.columns, (ExceptionListener)new ExceptionHandler());
    }

    public void load() {
        this.programs = this.dataLoader.load(SQL_PROGRAM, (RowExtractor)new RowTypeSGDPROGRAMExtractor());
        this.generics = this.dataLoader.load(SQL_PROGRAM_GENERIC, (RowExtractor)new GenericTypeExtractor());
        this.casts = this.dataLoader.load(SQL_PROGRAM_CAST, (RowExtractor)new CASTNAMEROLETypeExtractor());
        this.credits = this.dataLoader.load(SQL_PROGRAM_CREDITS, (RowExtractor)new CREDITSNAMEROLETypeExtractor());
        this.ratings = this.dataLoader.load(SQL_PROGRAM_RATING, (RowExtractor)new RatingTypeExtractor());
        this.audioComponentAttributes = this.dataLoader.load(SQL_PROGRAM_AUDIO, (RowExtractor)new ComponentAttributeExtractor(), this.columnsProgramIdTypeLanguange);
        this.audioComponentTypes = this.dataLoader.load(SQL_PROGRAM_AUDIO_TL, (RowExtractor)new AudioComponentTypeExtractor());
        this.subtitleComponentAttributes = this.dataLoader.load(SQL_PROGRAM_SUBTITLE, (RowExtractor)new ComponentAttributeExtractor(), this.columnsProgramIdTypeLanguange);
        this.subtitleComponentTypes = this.dataLoader.load(SQL_PROGRAM_SUBTITLE_TL, (RowExtractor)new SubtitleComponentTypeExtractor());
    }

    public OrderListValueMap<GenericType> getGenerics() {
        return this.generics;
    }

    public OrderListValueMap<RowTypeSGDPROGRAM> getPrograms() {
        return this.programs;
    }

    public OrderListValueMap<CASTNAMEROLEType> getCasts() {
        return this.casts;
    }

    public OrderListValueMap<CREDITSNAMEROLEType> getCredits() {
        return this.credits;
    }

    public OrderListValueMap<RatingType> getRatings() {
        return this.ratings;
    }

    public OrderListValueMap<ComponentAttribute> getAudioComponentAttributes() {
        return this.audioComponentAttributes;
    }

    public OrderListValueMap<AudioComponentType> getAudioComponentTypes() {
        return this.audioComponentTypes;
    }

    public OrderListValueMap<ComponentAttribute> getSubtitleComponentAttributes() {
        return this.subtitleComponentAttributes;
    }

    public OrderListValueMap<SubtitleComponentType> getSubtitleComponentTypes() {
        return this.subtitleComponentTypes;
    }
}

