/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer.dataloader;

import com.ericsson.cms.epgmgmt.export.bo.EventIdType;
import com.ericsson.cms.epgmgmt.export.bo.EventIdTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.GenericTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULE;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSCHEDULEExtractor;
import com.ericsson.cms.epgmgmt.export.bo.SeriesAttributeType;
import com.ericsson.cms.epgmgmt.export.bo.SeriesAttributeTypeExtractor;
import com.ericsson.cms.epgmgmt.export.worker.ExceptionHandler;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.beans.ExceptionListener;
import javax.sql.DataSource;

public class ScheduleLoader {
    private static final String SQL_SCHEDULE = "select * from exp_SCHEDULE order by station_id, program_id, Start_time";
    private static final String SQL_SCHEDULE_EVENT_ID = "select * from exp_SCHEDULE_EVENT_ID order by Identifier_Type";
    private static final String SQL_SCHEDULE_SERIES_ATTRIBUTE = "select * from exp_SCHEDULE_SERIES_ATTRIB order by Attribute_Type";
    private static final String SQL_SCHEDULE_GENERIC = "select * from exp_SCHEDULE_GENERIC order by Name";
    private final DataLoader dataLoader;
    private final String[] columns = new String[]{"PROGRAM_ID"};
    private OrderListValueMap<RowTypeSGDSCHEDULE> schedules;
    private OrderListValueMap<GenericType> generics;
    private OrderListValueMap<EventIdType> eventIds;
    private OrderListValueMap<SeriesAttributeType> seriesAttibute;

    public ScheduleLoader(DataSource dataSource) {
        this.dataLoader = new DataLoader(dataSource, this.columns, (ExceptionListener)new ExceptionHandler());
    }

    public void load() {
        this.schedules = this.dataLoader.load(SQL_SCHEDULE, (RowExtractor)new RowTypeSGDSCHEDULEExtractor());
        this.generics = this.dataLoader.load(SQL_SCHEDULE_GENERIC, (RowExtractor)new GenericTypeExtractor());
        this.eventIds = this.dataLoader.load(SQL_SCHEDULE_EVENT_ID, (RowExtractor)new EventIdTypeExtractor());
        this.seriesAttibute = this.dataLoader.load(SQL_SCHEDULE_SERIES_ATTRIBUTE, (RowExtractor)new SeriesAttributeTypeExtractor());
    }

    public OrderListValueMap<GenericType> getGenerics() {
        return this.generics;
    }

    public OrderListValueMap<RowTypeSGDSCHEDULE> getSchedules() {
        return this.schedules;
    }

    public OrderListValueMap<EventIdType> getEventIds() {
        return this.eventIds;
    }

    public OrderListValueMap<SeriesAttributeType> getSeriesAttibute() {
        return this.seriesAttibute;
    }
}

