/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.export.worker.producer.dataloader;

import com.ericsson.cms.epgmgmt.export.bo.GenericType;
import com.ericsson.cms.epgmgmt.export.bo.GenericTypeExtractor;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATION;
import com.ericsson.cms.epgmgmt.export.bo.RowTypeSGDSTATIONExtractor;
import com.ericsson.cms.epgmgmt.export.worker.ExceptionHandler;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.misc.OrderListValueMap;
import java.beans.ExceptionListener;
import javax.sql.DataSource;

public class StationLoader {
    private static final String SQL_STATION = "select * from exp_station order by station_id";
    private static final String SQL_STATION_GENERIC = "select * from exp_station_generic order by Name";
    private final String[] columns = new String[]{"station_id"};
    private final DataLoader dataLoader;
    private OrderListValueMap<GenericType> generics = null;
    private OrderListValueMap<RowTypeSGDSTATION> station;
    private final boolean isStationGenericSupported;

    public StationLoader(DataSource dataSource, boolean isStationGenericSupported) {
        this.dataLoader = new DataLoader(dataSource, this.columns, (ExceptionListener)new ExceptionHandler());
        this.isStationGenericSupported = isStationGenericSupported;
    }

    public void load() {
        if (this.isStationGenericSupported) {
            this.generics = this.dataLoader.load(SQL_STATION_GENERIC, (RowExtractor)new GenericTypeExtractor());
        }
        this.station = this.dataLoader.load(SQL_STATION, (RowExtractor)new RowTypeSGDSTATIONExtractor());
    }

    public OrderListValueMap<RowTypeSGDSTATION> getStations() {
        return this.station;
    }

    public OrderListValueMap<GenericType> getGenerics() {
        return this.generics;
    }
}

