/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job;

import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.job.CancelChecker;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.ProgressMonitor;
import com.ericsson.cms.epgmgmt.job.ThreadLocalCancelChecker;
import com.ericsson.cms.epgmgmt.job.ThreadLocalProgressMonitor;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.PartnerIdThreadLocal;
import java.util.concurrent.CancellationException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractManageableProcessor
implements Processor,
ProgressMonitor,
CancelChecker {
    private long jobId;
    private String stepName;
    private int progress = 0;
    private Exchange exchange;
    private long partnerId;
    private Job job;
    private static Log logger = LogFactory.getLog(AbstractManageableProcessor.class);

    public void process(Exchange exchange) throws Exception {
        logger.info((Object)("Job Step start:" + this.getClass().getName()));
        this.init(exchange);
        this.job.stepStart(this.getStepName(), this);
        try {
            this.innerProcess(exchange);
            this.job.stepEnd("");
            logger.info((Object)("Job Step end:" + this.getStepName()));
        }
        catch (Exception ex) {
            logger.error((Object)"Job Step error:", (Throwable)ex);
            this.job.stepError(ex.getMessage());
            this.job.getJobEntity().setErrorMessage(this.getRootException(ex));
            this.job.setStatus(JobStatusEnum.FAILDED);
            throw ex;
        }
        catch (Throwable th) {
            logger.error((Object)"Job Step error:", th);
            this.job.stepError(this.getRootException(th));
            this.job.setStatus(JobStatusEnum.FAILDED);
            this.job.getJobEntity().setErrorMessage(this.getRootException(th));
            throw new Exception("Unknown error", th);
        }
        finally {
            this.clear();
        }
    }

    private String getRootException(Throwable th) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)th);
        return root == null ? th.getMessage() : root.getMessage();
    }

    private void clear() {
        ThreadLocalCancelChecker.set(null);
        ThreadLocalProgressMonitor.set(null);
        this.exchange = null;
    }

    private void init(Exchange exchange) {
        this.exchange = exchange;
        this.job = (Job)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
        if (this.job.isCanceled()) {
            logger.info((Object)"Job has been canceled");
            throw new CancellationException("Job has been canceled.");
        }
        this.jobId = this.job.getId();
        this.partnerId = this.job.getJobEntity().getPartnerId();
        ThreadLocalCancelChecker.set(this);
        ThreadLocalProgressMonitor.set(this);
        PartnerIdThreadLocal.setPartnerId(this.partnerId);
        MessageEntryUtil.setMessageEntryList(this.job.getMessages());
    }

    protected abstract void innerProcess(Exchange var1) throws Exception;

    public String getStepName() {
        return this.stepName;
    }

    @Override
    public void setProgress(int percentage) {
        if (this.progress != percentage) {
            this.progress = Math.max(Math.min(percentage, 100), 0);
            this.job.setCurStepProgress(this.progress);
        }
    }

    public void cancel() {
    }

    public boolean isCanceled() {
        boolean bCancel = false;
        if (this.exchange != null && this.job != null) {
            bCancel = this.job.isCanceled();
        }
        return bCancel;
    }

    public long getJobId() {
        return this.jobId;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Override
    public void checkCancel() {
        if (this.isCanceled()) {
            throw new CancellationException("The job has been canceled.");
        }
    }

    protected long getPartnerId() {
        return this.partnerId;
    }

    protected IJob getJob() {
        return this.job;
    }

    protected boolean isIngest() {
        return this.job.getJobEntity().getType() == TaskTypeEnum.INGEST;
    }
}

