/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.accessor.JobDataMapAccessor;
import com.ericsson.cms.epgmgmt.cluster.accessor.TokenMapAccessor;
import com.ericsson.cms.epgmgmt.cluster.data.JobStatusData;
import com.ericsson.cms.epgmgmt.cluster.message.TaskJobTopicMessage;
import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import com.ericsson.cms.epgmgmt.dto.JobCommentsDto;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.JobEntity;
import com.ericsson.cms.epgmgmt.entity.JobTrace;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.job.CancellableChecker;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.JobDto;
import com.ericsson.cms.epgmgmt.job.JobStep;
import com.ericsson.cms.epgmgmt.job.JobStepWeight;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.job.PreEventHandler;
import com.ericsson.cms.epgmgmt.job.ShutdownStrategy;
import com.ericsson.cms.epgmgmt.job.handler.JobStatusChangeHandler;
import com.ericsson.cms.epgmgmt.job.recovery.JobRecoverer;
import com.ericsson.cms.epgmgmt.job.recovery.RecoverJobChecker;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.plugin.JarClassLoader;
import com.ericsson.cms.epgmgmt.service.ActivityLogger;
import com.ericsson.cms.epgmgmt.service.ICamelManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.IJobManager;
import com.ericsson.cms.epgmgmt.service.IJobTraceManager;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.util.JobCommentsUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.cms.epgmgmt.utility.json.JsonUtil;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.Member;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class CamelTaskJobExecutor
implements ITaskJobExecutor,
Runnable {
    private static final String DEFAULT_EPG_JOBQUEUE_BAK_FILE = "epg-jobqueue.bak";
    private static final ShutdownStrategy DEFAULT_SHUTDOWN_STRATEGY = ShutdownStrategy.SHUTDOWN_IMMEDIATELY;
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    private static final long DEFAULT_INTERVAL = 5000L;
    private static final int MAX_QUEUE_SIZE = 50;
    private static final int WAIT_MINUTES = 5;
    private final Logger logger = Logger.getLogger(CamelTaskJobExecutor.class);
    private final BlockingQueue<Job> jobQueue = new LinkedBlockingQueue<Job>(50);
    private final Lock queueLock;
    private final Lock jobEventLock;
    private final Condition jobEventCondition;
    private final List<PreEventHandler> preEventHandlers;
    private final List<PostEventHandler> postEventHandlers;
    private boolean stopped = false;
    private IEPGMetadataManager epgMetadataManager;
    private ICamelManager camelManager;
    private HazelcastManager hazelcastManager;
    private TokenMapAccessor tokenMapAccessor;
    private Thread thread = null;
    private IJobManager jobManager;
    private IJob currentJob;
    private final Pattern jobStepsPattern = Pattern.compile("^(.*)\\((\\d+)\\)$");
    private List<JobStepWeight> ingestStepWeight;
    private List<JobStepWeight> exportStepWeight;
    private final Lock runningLock;
    private List<JobStatusChangeHandler> jobStatusChangeHandlers;
    private ITaskManager taskManager;
    private JobRecoverer jobRecoverer;
    private IJobTraceManager jobTraceManager;
    private JobDataMapAccessor jobDataMapAccessor;
    private long shutdownTimeout = 5000L;
    private int folderSpaceCancelJobLimit = 500;
    private int folderSpaceWarnLimit = 2;
    private long interval = 5000L;
    private ShutdownStrategy shutdownStrategy = DEFAULT_SHUTDOWN_STRATEGY;
    private String queueBackupPath = System.getProperty("java.io.tmpdir") + File.separator + "epg-jobqueue.bak";
    private RecoverJobChecker recoverJobChecker;
    private String criticalStepNames;
    private static final int STATUS_TASK_RUNNING = 1;
    private static final int STATUS_ANOTHER_TASK_RUNNING = 2;
    private static final int STATUS_ERROR_HAPPEND = 3;
    private static final int STATUS_SUCCESS = 0;

    public CamelTaskJobExecutor() {
        this.queueLock = new ReentrantLock();
        this.jobEventLock = new ReentrantLock();
        this.runningLock = new ReentrantLock();
        this.jobEventCondition = this.jobEventLock.newCondition();
        this.postEventHandlers = new ArrayList<PostEventHandler>();
        this.preEventHandlers = new ArrayList<PreEventHandler>();
        new ObjectMapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void start() {
        this.runningLock.lock();
        try {
            if (this.isRunning()) {
                this.logger.warn((Object)"Try to start task job executor but it is running already.");
                return;
            }
            this.logger.info((Object)"Starting task executor ...");
            this.stopped = false;
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.setName("CamelTaskJobExecutor");
            this.thread.start();
            this.logger.info((Object)"Task executor started.");
        }
        finally {
            this.runningLock.unlock();
        }
        int recovered = this.jobRecoverer.recover();
        this.logger.info((Object)(recovered + " job(s) has been recovered."));
        this.loadJobsFromBackup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        this.gracefulShutdown();
        this.runningLock.lock();
        try {
            if (!this.isRunning()) {
                this.logger.warn((Object)"Try to stop task job executor ,but it is not running yet.");
                return;
            }
            this.logger.info((Object)"Stoping task executor");
            this.stopped = true;
            this.jobQueue.clear();
            this.thread.interrupt();
        }
        finally {
            this.runningLock.unlock();
        }
    }

    private void backupQueue() {
        try {
            ArrayList<JobDto> l = new ArrayList<JobDto>(this.jobQueue.size() + 1);
            IJob running = this.currentJob;
            if (running != null && running.getContext().get("marked.for.recovery") == null) {
                l.add(this.copyJobForBackup(running));
            }
            for (Job job : this.jobQueue) {
                l.add(this.copyJobForBackup(job));
            }
            this.logger.info((Object)("Backing up (" + l.size() + ") jobs from queue to file[" + this.queueBackupPath + "]"));
            JsonUtil.WriteValueToFile(l, (File)new File(this.queueBackupPath));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot backup jobs in queue to file", (Throwable)e);
        }
    }

    private JobDto copyJobForBackup(IJob job) {
        JobDto dto = new JobDto();
        dto.setPartnerId(job.getTask().getPartner().getId()).setTaskId(job.getTask().getId()).setType(job.getTask().getType()).setTriggerType(job.getTask().getTriggerType()).setStart(job.getJobEntity().getStartDate()).setEnd(job.getJobEntity().getEndDate()).getContext().putAll(job.getContext());
        return dto;
    }

    private void loadJobsFromBackup() {
        try {
            File file = new File(this.queueBackupPath);
            if (!file.exists()) {
                return;
            }
            JobDto[] jobs = (JobDto[])JsonUtil.readArray((File)file, JobDto.class);
            if (jobs == null) {
                return;
            }
            this.logger.info((Object)("Loading (" + jobs.length + ") jobs from file[" + this.queueBackupPath + "]"));
            for (JobDto job : jobs) {
                if (job.getContext().containsKey("trigger.time")) {
                    job.getContext().put("trigger.time", new Date((Long)job.getContext().get("trigger.time")));
                }
                Member node = this.tokenMapAccessor.getToken(KeyUtil.getJobTokenKey(job.getTaskId(), job.getTriggerType() == TaskTriggerTypeEnum.MANUAL ? null : (Date)job.getContext().get("trigger.time")), Member.class);
                if (this.hazelcastManager.getLocalServer() != null && this.hazelcastManager.getLocalServer().equals(node)) {
                    this.jobDataMapAccessor.eraseJobStatus(job.getTaskId());
                    this.hazelcastManager.releaseToken(KeyUtil.getJobPartnerTokenKey(String.valueOf(job.getPartnerId())));
                    if (job.getTriggerType() == TaskTriggerTypeEnum.MANUAL) {
                        this.hazelcastManager.releaseToken(KeyUtil.getJobTokenKey(job.getTaskId(), null));
                    }
                }
                if (!this.recoverJobChecker.shouldRecover(job)) continue;
                String comments = (String)job.getContext().get("comments");
                job.getContext().put("comments", StringUtils.isBlank((String)comments) ? "job.comments.rerun.from.shutdown" : comments + "," + "job.comments.rerun.from.shutdown");
                this.startTask(this.taskManager.getTask(job.getTaskId()), (Map)job.getContext());
            }
            FileUtils.deleteQuietly((File)file);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error reloading the backup jobs", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopped) {
            IJob job = this.pollJob();
            if (job == null) continue;
            this.setCurrentJob(job);
            switch (this.addCamelRoute(job)) {
                case 0: {
                    this.waitJobFinish(job);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (job.getTask().getTriggerType() != TaskTriggerTypeEnum.MANUAL) break;
                    String message = ApplicationContextUtil.getMessage((String)"job.cancelToStartNewTask", (Object[])new Object[0]);
                    job.getJobEntity().setErrorMessage("ERR_TASK_EXECUTING");
                    this.logAndEndJob(job, message);
                    break;
                }
                case 3: {
                    this.logAndEndJob(job, ApplicationContextUtil.getMessage((String)"job.cancelInternalError", (Object[])new Object[0]));
                    break;
                }
            }
            this.setCurrentJob(null);
        }
        this.logger.info((Object)"Task executor stopped.");
        this.runningLock.lock();
        try {
            this.thread = null;
            this.jobQueue.clear();
            this.currentJob = null;
        }
        finally {
            this.runningLock.unlock();
        }
    }

    private void logAndEndJob(IJob job, String reason) {
        try {
            ((Job)job).getMessages().add(new MessageEntry(EmailAlertLevelEnum.WARNING, "", reason, PluginLogComponent.WORKFLOW));
            this.endJob(job);
        }
        catch (Exception e) {
            this.logger.error((Object)("error happen when trying to end job[" + job + "]"), (Throwable)e);
        }
    }

    private IJob pollJob() {
        while (!this.stopped) {
            Job job = null;
            try {
                job = this.jobQueue.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (job.isCanceled()) {
                this.saveCaneledJob(job);
                continue;
            }
            return job;
        }
        return null;
    }

    private void saveCaneledJob(Job job) {
        if (job.getTask().isManual() || this.acquiredToken(job)) {
            job.setStatus(JobStatusEnum.CANCELD);
            this.jobManager.update(job.getJobEntity());
            this.fireJobFinishEvent(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitJobFinish(IJob job) {
        String routeId = RouteBuilderUtils.getRouteId(job.getTask());
        this.jobEventLock.lock();
        try {
            do {
                try {
                    if (this.jobEventCondition.await(5L, TimeUnit.MINUTES)) {
                    } else if (this.camelManager.getCamelContext().getInflightRepository().size(routeId) > 0) continue;
                    break;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (!this.stopped);
        }
        finally {
            this.jobEventLock.unlock();
        }
        try {
            this.camelManager.removeTaskRoute(job.getTask());
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Error happens when stop the task %s in camel", job.getTask().getName()), (Throwable)e);
        }
    }

    private int addCamelRoute(IJob job) {
        String providerId = null;
        providerId = job.getTask().getType() == TaskTypeEnum.INGEST ? String.valueOf(job.getTask().getPartner().getId()) : this.taskManager.getExportTaskSpecifiedProviderId(job.getTask());
        if (!this.acquiredToken(job)) {
            String info = "The task[" + job.getTask().getName() + "]  has been abandoned, because it is running on or executed by another node";
            this.logger.warn((Object)info);
            job.getJobEntity().setErrorMessage(info);
            return 1;
        }
        if (StringUtils.isNotEmpty((String)providerId) && !this.acquirePartnerToken(providerId)) {
            job.cancel();
            job.setStatus(JobStatusEnum.CANCELD);
            this.jobManager.createJob(job.getJobEntity());
            this.createJobTrace(job.getJobEntity(), null, true);
            return 2;
        }
        EpgFormat format = this.epgMetadataManager.getEpgFormat(job.getTask());
        boolean isPluginFileExists = this.checkTaskFormatFileExists(job.getTask(), format);
        if (!isPluginFileExists) {
            return this.cancelJob(job);
        }
        boolean isCanToBeRunning = this.checkWorkFolderSpace(job.getTask());
        if (!isCanToBeRunning) {
            return this.cancelJob(job);
        }
        try {
            if (this.camelManager.getCamelContext().getRoute(RouteBuilderUtils.getRouteId(job.getTask())) != null) {
                this.logger.warn((Object)"There is another task job in camel context already.");
                this.camelManager.removeTaskRoute(job.getTask());
            }
            job.getJobEntity().setStartDate(new Date());
            job.setStatus(JobStatusEnum.RUNNING);
            Member node = this.tokenMapAccessor.getToken(KeyUtil.getJobTokenKey(job), Member.class);
            if (node != null) {
                job.getJobEntity().setRunOn(node.getInetSocketAddress().getAddress().getHostAddress());
            }
            this.jobManager.createJob(job.getJobEntity());
            this.createJobTrace(job.getJobEntity(), node);
            this.camelManager.createTaskRoute(job);
        }
        catch (Exception e) {
            String error = String.format("Error happens when executing the task %s in camel", job.getTask().getName());
            this.logger.error((Object)error, (Throwable)e);
            job.getJobEntity().setErrorMessage("ERR_CAMEL");
            job.setStatus(JobStatusEnum.FAILDED);
            return 3;
        }
        return 0;
    }

    private int cancelJob(IJob job) {
        job.cancel();
        job.getJobEntity().setErrorMessage("ERR_CAMEL");
        job.setStatus(JobStatusEnum.FAILDED);
        return 3;
    }

    private boolean checkWorkFolderSpace(Task task) {
        int warnLimit = this.folderSpaceWarnLimit;
        int downLimit = this.folderSpaceCancelJobLimit;
        String folder = JarClassLoader.getPluginWorkTmpFolder();
        try {
            String[] infos = com.ericsson.cms.epgmgmt.utility.io.FileUtils.getFolderSpaceInfoByCommand((String)folder);
            if (infos == null || infos.length < 3) {
                String msg = "Get the folder " + folder + " disk space information failure";
                this.logger.warn((Object)msg);
                return true;
            }
            String totalSpaceStr = infos[1];
            String availSpaceStr = infos[3];
            float totalSpace = (float)Integer.parseInt(totalSpaceStr) / 1024.0f / 1024.0f;
            float availSpaceM = (float)Integer.parseInt(availSpaceStr) / 1024.0f;
            float availSpace = availSpaceM / 1024.0f;
            String unit = "G";
            if (availSpace < 1.0f) {
                unit = "M";
                availSpace *= 1024.0f;
                warnLimit *= 1024;
            }
            BigDecimal totalSpaceBD = new BigDecimal(totalSpace).setScale(2, 0);
            BigDecimal availSpaceBD = new BigDecimal(availSpace).setScale(2, 0);
            String msg = String.format("The free space on the folder \"%s\" is %s. The total space is %sG. ", folder, availSpaceBD.floatValue() + unit, Float.valueOf(totalSpaceBD.floatValue()));
            this.logger.info((Object)msg);
            if (totalSpace < 0.0f || availSpace < 0.0f) {
                this.logger.warn((Object)"Got the disk space information failure");
                return true;
            }
            if (availSpaceM > (float)downLimit && availSpaceBD.floatValue() <= (float)warnLimit) {
                String warnInfo = "The free space on the folder \" " + folder + "\" is almost full. " + msg;
                this.writeActivityLog(task, warnInfo, PluginLogSeverity.WARNING);
                this.logger.warn((Object)warnInfo);
            } else if (availSpaceM <= (float)downLimit) {
                String warnInfo = "The free space on the folder \" " + folder + "\" is almost full. " + msg;
                warnInfo = warnInfo + "\nCancel current job.";
                this.logger.warn((Object)warnInfo);
                this.writeActivityLog(task, warnInfo, PluginLogSeverity.CRITICAL);
                return false;
            }
        }
        catch (Exception e) {
            String msg = "Get the folder " + folder + " disk space Information failure. \n" + e.getMessage();
            this.logger.warn((Object)msg);
        }
        return true;
    }

    private boolean checkTaskFormatFileExists(Task task, EpgFormat format) {
        if (format == null) {
            return true;
        }
        String fileName = format.getJarName();
        File pluginFile = new File(fileName);
        if (!pluginFile.exists()) {
            String info = String.format("Can not find the plugin file [%s],  Please check the Plugin file or reinstall this plugin.", fileName);
            info = info + "\nCancel current job.";
            this.writeActivityLog(task, info, PluginLogSeverity.CRITICAL);
            this.logger.warn((Object)info);
            return false;
        }
        return true;
    }

    private void writeActivityLog(Task task, String info, PluginLogSeverity severity) {
        ActivityLogger.getInstance().log(severity, PartnerTypeEnum.Provider.toString().equalsIgnoreCase(task.getPartner().getPartnerType().toString()) ? PluginLogComponent.INGEST : PluginLogComponent.PUBLISH, info, task.getPartner().getId(), task.getPartner().getPartnerType().toString());
    }

    private void createJobTrace(JobEntity jobEntity, Member node, boolean isFinished) {
        JobTrace jobTrace = new JobTrace();
        jobTrace.setJobId(jobEntity.getId());
        jobTrace.setStartTime(jobEntity.getStartDate());
        jobTrace.setNodeAddress(jobEntity.getRunOn());
        if (node != null) {
            jobTrace.setNodePort(node.getInetSocketAddress().getPort());
        }
        jobTrace.setFinished(isFinished);
        this.jobTraceManager.createJobTrace(jobTrace);
    }

    private void createJobTrace(JobEntity jobEntity, Member node) {
        this.createJobTrace(jobEntity, node, false);
    }

    private boolean acquiredToken(IJob job) {
        return this.hazelcastManager.acquireToken(KeyUtil.getJobTokenKey(job));
    }

    private boolean acquirePartnerToken(String partnerId) {
        return this.hazelcastManager.acquireToken(KeyUtil.getJobPartnerTokenKey(partnerId));
    }

    private void releasePartnerToken(IJob job) {
        if (job.getTask().getType() == TaskTypeEnum.INGEST) {
            this.hazelcastManager.releaseToken(KeyUtil.getJobPartnerTokenKey(String.valueOf(job.getTask().getPartner().getId())));
        } else {
            String specifiedProviderId = this.taskManager.getExportTaskSpecifiedProviderId(job.getTask());
            if (StringUtils.isNotEmpty((String)specifiedProviderId)) {
                this.hazelcastManager.releaseToken(KeyUtil.getJobPartnerTokenKey(specifiedProviderId));
            }
        }
    }

    public IJob startTask(Task task) {
        return this.startTask(task, (Map)new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job startTask(Task task, Map<String, Object> params) {
        Job job;
        this.queueLock.lock();
        if (!this.checkExecutorRunning()) {
            return null;
        }
        try {
            job = (Job)this.getTaskJob(task.getId());
            if (job != null) {
                this.logger.warn((Object)String.format("Skipped this task %s because it is already in the queue or is running on this node.", task.getName()));
                Job job2 = job;
                return job2;
            }
            job = new Job(task, this.jobStatusChangeHandlers);
            job.setCriticalStepNames(this.criticalStepNames);
            job.setStepWeight(task.getType() == TaskTypeEnum.INGEST ? this.ingestStepWeight : this.exportStepWeight);
            job.getContext().putAll(params);
            this.addRecoverComments(params, job);
            if (!this.jobQueue.offer(job)) {
                this.skipJob(job);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("Cannot start job for task[" + task + "]"), (Throwable)e);
            Job job3 = null;
            return job3;
        }
        finally {
            this.queueLock.unlock();
        }
        this.fireJobStartEvent(job);
        return job;
    }

    private void addRecoverComments(Map<String, Object> params, Job job) throws Exception {
        JobCommentsDto comments = new JobCommentsDto();
        if (params.containsKey("comments")) {
            comments.setComments((String)params.get("comments"));
            job.getContext().put("comments", params.get("comments"));
        }
        if (params.containsKey("recovered.from")) {
            this.logger.info((Object)("Job[" + job.getId() + "] is created on server [" + this.hazelcastManager.getLocalServer().getInetSocketAddress().getAddress().getHostAddress() + "] to recover Job[" + params.get("recovered.from")));
            comments.setRecoveredFrom((Long)params.get("recovered.from"));
            job.getContext().put("recovered.from", params.get("recovered.from"));
        }
        job.getJobEntity().setComments(JsonUtil.writeValue((Object)comments));
    }

    private boolean checkExecutorRunning() {
        boolean result = true;
        if (!this.isRunning()) {
            this.logger.error((Object)"The task executor is not running.");
            result = false;
        }
        if (!this.camelManager.isCamelRunning()) {
            this.logger.error((Object)"The camel is not running.");
            result = false;
        }
        return result;
    }

    private void skipJob(Job job) {
        job.setStatus(JobStatusEnum.FAILDED);
        String errorMessage = "Skipped because the task queue reaches the maximum size.";
        job.getJobEntity().setErrorMessage("ERR_QUEUE_FULL");
        this.jobManager.update(job.getJobEntity());
        this.fireJobFinishEvent(job);
        this.logger.warn((Object)errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endJob(IJob job) {
        Job j = (Job)job;
        try {
            j.buildStepInfo();
            JobStatusEnum status = j.getJobEntity().getStatus();
            j.getJobEntity().setEndDate(new Date());
            if (status == JobStatusEnum.RUNNING || status == JobStatusEnum.QUEUING) {
                j.setStatus(this.getJobStatus(j));
            }
            this.jobManager.update(j.getJobEntity());
            this.fireJobFinishEvent(j);
        }
        finally {
            this.jobEventLock.lock();
            try {
                this.jobEventCondition.signalAll();
            }
            finally {
                this.jobEventLock.unlock();
            }
            this.releasePartnerToken(j);
        }
    }

    private JobStatusEnum getJobStatus(Job job) {
        if (job.isCanceled()) {
            return JobStatusEnum.CANCELD;
        }
        for (JobStep step : job.getSteps()) {
            if (step.getStatus() != JobStatusEnum.FAILDED) continue;
            return JobStatusEnum.FAILDED;
        }
        return JobStatusEnum.COMPLETED;
    }

    public List<IJob> getRunningJobs() {
        LinkedList<IJob> result = new LinkedList<IJob>(this.jobQueue);
        IJob curJob = this.currentJob;
        if (curJob != null) {
            result.add(curJob);
        }
        return result;
    }

    public void stopJob(IJob job) {
        job.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLocalJobForTask(long taskId) {
        this.queueLock.lock();
        try {
            if (this.currentJob != null && this.currentJob.getTask().getId() == taskId) {
                this.stopJob(this.currentJob);
            }
            for (Job job : this.jobQueue) {
                if (job.getTask().getId() != taskId || job.isCanceled()) continue;
                this.stopJob(job);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public void stopJobForTask(Task task) {
        TaskJobTopicMessage message = new TaskJobTopicMessage(task.getId(), "Cancel");
        this.hazelcastManager.getTaskJobTopic().publish((Object)message);
    }

    public void setPreEventHandlers(List<PreEventHandler> preEventHandlers) {
        this.preEventHandlers.clear();
        this.preEventHandlers.addAll(preEventHandlers);
    }

    public void setPostEventHandlers(List<PostEventHandler> postEventHandlers) {
        this.postEventHandlers.clear();
        this.postEventHandlers.addAll(postEventHandlers);
    }

    private void fireJobStartEvent(IJob job) {
        for (PreEventHandler jobHandler : this.preEventHandlers) {
            try {
                jobHandler.beforeJobStart(job);
            }
            catch (Exception ex) {
                this.logger.error((Object)("Error occurs when handling the starting event of the job:" + job.getId()), (Throwable)ex);
            }
        }
    }

    private void fireJobFinishEvent(IJob job) {
        for (PostEventHandler jobHandler : this.postEventHandlers) {
            try {
                jobHandler.afterJobDone(job);
            }
            catch (Exception ex) {
                this.logger.error((Object)("Error occurs when handling finishing event of the job:" + job.getId()), (Throwable)ex);
            }
        }
    }

    @Autowired
    public void setJobManager(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    public synchronized IJob getCurrentJob() {
        return this.currentJob;
    }

    @Autowired
    public void setCamelManager(ICamelManager camelManager) {
        this.camelManager = camelManager;
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    private synchronized void setCurrentJob(IJob job) {
        this.currentJob = job;
    }

    public boolean isCancellable(long taskId) {
        JobStatusData jobStatus = this.jobDataMapAccessor.getJobStatus(taskId);
        if (jobStatus == null) {
            return true;
        }
        return this.isClusterCancellable(taskId, jobStatus);
    }

    private boolean isClusterCancellable(long taskId, JobStatusData jobStatus) {
        Member node = this.tokenMapAccessor.getToken(KeyUtil.getJobTokenKey(jobStatus), Member.class);
        if (node == null) {
            return true;
        }
        if (!this.hazelcastManager.isRemoteSeverWork(node)) {
            return true;
        }
        DistributedTask task = new DistributedTask((Callable)new CancellableChecker(taskId), node);
        ExecutorService executorService = Hazelcast.getExecutorService();
        executorService.execute((Runnable)task);
        boolean result = false;
        try {
            result = (Boolean)task.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            String addr = null;
            try {
                addr = node.getInetSocketAddress().getAddress().getHostAddress();
            }
            catch (Exception e) {
                addr = "unknown";
            }
            this.logger.error((Object)("Error occurred while getting the plugin cancellable attribute from " + addr), (Throwable)ex);
        }
        return result;
    }

    public Boolean isLocalJobCancellableForTask(long taskId) {
        if (this.currentJob == null) {
            return true;
        }
        if (this.currentJob.getTask() == null) {
            return true;
        }
        if (this.currentJob.getTask().getId() != taskId) {
            return true;
        }
        return this.currentJob.isCancellable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJob getTaskJob(long taskId) {
        this.queueLock.lock();
        try {
            IJob curJob = this.getCurrentJob();
            if (curJob != null && !curJob.isCanceled() && curJob.getTask().getId() == taskId) {
                IJob iJob = curJob;
                return iJob;
            }
            for (Job job : this.jobQueue) {
                if (job.getTask().getId() != taskId || job.isCanceled()) continue;
                Job job2 = job;
                return job2;
            }
            IJob iJob = null;
            return iJob;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    public void setIngestStepWeight(String ingestStepWeight) {
        this.ingestStepWeight = this.parseWeight(ingestStepWeight);
    }

    public void setExportStepWeight(String exportStepWeight) {
        this.exportStepWeight = this.parseWeight(exportStepWeight);
    }

    private List<JobStepWeight> parseWeight(String ingestStepWeight) {
        ArrayList<JobStepWeight> list = new ArrayList<JobStepWeight>();
        String[] stepWeights = ingestStepWeight.split(",");
        int currentProgress = 0;
        for (String stepWeight : stepWeights) {
            Matcher m = this.jobStepsPattern.matcher(stepWeight);
            if (!m.find()) continue;
            Integer weight = Integer.valueOf(m.group(2));
            list.add(new JobStepWeight(m.group(1), weight, currentProgress));
            currentProgress += weight.intValue();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulShutdown() {
        if (this.stopped) {
            return;
        }
        this.logger.info((Object)"Gracefully shutting down job executor");
        try {
            this.runningLock.lock();
            this.stopped = true;
            switch (this.shutdownStrategy) {
                case WAIT_FOR_CURRENT: {
                    this.waitForCurrent();
                    break;
                }
                case WAIT_FOR_ALL: {
                    this.waitForAll();
                    break;
                }
                default: {
                    this.shutdownImmediately();
                }
            }
            this.jobQueue.clear();
            this.thread.interrupt();
        }
        catch (Exception e) {
            this.logger.warn((Object)"error", (Throwable)e);
        }
        finally {
            this.runningLock.unlock();
        }
    }

    @Transactional(readOnly=true)
    private void shutdownImmediately() {
        IJob running = this.currentJob;
        if (running != null) {
            if (running.getJobEntity().getTriggerType() == TaskTriggerTypeEnum.SCHEDULE) {
                running.getContext().put("marked.for.recovery", true);
            }
            this.logger.info((Object)("Canceling running job[" + running.getId() + "]"));
            JobCommentsUtil.updateComments(running.getJobEntity(), "job.comments.running.while.shutdown");
            running.cancel();
        }
        this.backupQueue();
        if (running != null && running.getId() > 0L) {
            for (long waited = 0L; waited < this.shutdownTimeout; waited += this.interval) {
                JobTrace jt = this.jobTraceManager.getJobTrace(running.getId());
                if (jt == null || jt.isFinished()) {
                    return;
                }
                this.logger.info((Object)("Job[" + running.getId() + "] is not canceled yet, wait for another 5 seconds"));
                this.sleepSilently(this.interval);
            }
            this.logger.info((Object)("Cannot cancel job[" + running.getId() + "] within [" + 5L + "] seconds, forcely fail the job"));
            running.setStatus(JobStatusEnum.FAILDED);
            this.jobManager.update(running.getJobEntity());
            if (running.getContext().get("marked.for.recovery") == null) {
                this.jobTraceManager.finishJobTrace(running.getId());
            }
        }
    }

    private void sleepSilently(long interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void waitForCurrent() {
        this.logger.warn((Object)"WAIT_FOR_CURRENT shutdown strategy is not supported now!");
    }

    private void waitForAll() {
        this.logger.warn((Object)"WAIT_FOR_ALL shutdown strategy is not supported now!");
    }

    public void setJobStatusChangeHandlers(List<JobStatusChangeHandler> jobStatusChangeHandlers) {
        this.jobStatusChangeHandlers = jobStatusChangeHandlers;
    }

    @Autowired
    public void setTokenMapAccessor(TokenMapAccessor tokenMapAccessor) {
        this.tokenMapAccessor = tokenMapAccessor;
    }

    @Autowired
    public void setJobRecoverer(JobRecoverer jobRecoverer) {
        this.jobRecoverer = jobRecoverer;
    }

    @Autowired
    public void setJobTraceManager(IJobTraceManager jobTraceManager) {
        this.jobTraceManager = jobTraceManager;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setWaitTimeout(long waitTimeout) {
    }

    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = shutdownStrategy;
    }

    public void setFolderSpaceCancelJobLimit(int folderSpaceCancelJobLimit) {
        this.folderSpaceCancelJobLimit = folderSpaceCancelJobLimit;
    }

    public void setFolderSpaceWarnLimit(int folderSpaceWarnLimit) {
        this.folderSpaceWarnLimit = folderSpaceWarnLimit;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setQueueBackupPath(String queueBackupPath) {
        if (StringUtils.isNotBlank((String)queueBackupPath)) {
            this.queueBackupPath = queueBackupPath;
        }
    }

    public void setCriticalStepNames(String criticalStepNames) {
        this.criticalStepNames = criticalStepNames;
    }

    public String getCriticalStepNames() {
        return this.criticalStepNames;
    }

    @Autowired
    public void setRecoverJobChecker(RecoverJobChecker recoverJobChecker) {
        this.recoverJobChecker = recoverJobChecker;
    }

    @Autowired
    public void setJobDataMapAccessor(JobDataMapAccessor jobDataMapAccessor) {
        this.jobDataMapAccessor = jobDataMapAccessor;
    }

    @Autowired
    public void setEpgMetadataManager(IEPGMetadataManager epgMetadataManager) {
        this.epgMetadataManager = epgMetadataManager;
    }
}

