/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job;

import com.ericsson.cms.epgmgmt.camel.processor.AbstractPluginProcessor;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.JobEntity;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.job.JobStep;
import com.ericsson.cms.epgmgmt.job.JobStepWeight;
import com.ericsson.cms.epgmgmt.job.handler.JobStatusChangeHandler;
import com.ericsson.cms.epgmgmt.service.IJob;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Processor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class Job
implements IJob {
    public static final String RETRY_COUNT = "Retry_Count";
    public static final String LACK_FILE = "Lack_File";
    private static final Log LOGGER = LogFactory.getLog(Job.class);
    private final transient List<JobStep> steps = new ArrayList<JobStep>();
    private transient JobStep currentStep;
    private JobEntity jobEntity;
    private final transient ObjectMapper mapper = new ObjectMapper();
    private boolean isCanceled = false;
    private final List<MessageEntry> messages = new ArrayList<MessageEntry>();
    private final Task task;
    private int progresss;
    private List<JobStepWeight> stepWeights;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private List<JobStatusChangeHandler> handlers;
    private String criticalStepNames;

    public Job(Task task) {
        this.jobEntity = new JobEntity();
        this.jobEntity.setType(task.getType());
        this.jobEntity.setTaskId(task.getId());
        this.jobEntity.setTaskName(task.getName());
        this.jobEntity.setPartnerId(task.getPartner().getId());
        this.jobEntity.setStartDate(new Date());
        this.jobEntity.setTriggerType(task.getTriggerType());
        this.jobEntity.setParameters(String.valueOf(task.getId()));
        this.jobEntity.setStatus(JobStatusEnum.QUEUING);
        this.task = task;
    }

    public Job(Task task, List<JobStatusChangeHandler> handlers) {
        this(task);
        this.handlers = handlers;
        this.fireChangeEvent();
    }

    public List<JobStep> getSteps() {
        return new LinkedList<JobStep>(this.steps);
    }

    public JobStep getCurrentStep() {
        return this.currentStep;
    }

    public void stepStart(String stepName, Processor processor) {
        JobStep step = new JobStep();
        step.setStartDate(new Date());
        step.setProgresss(0);
        step.setStatus(JobStatusEnum.RUNNING);
        step.setStepName(stepName);
        if (processor instanceof AbstractManageableProcessor) {
            step.setProcessor((AbstractManageableProcessor)processor);
        }
        step.setId(this.steps.size());
        this.steps.add(step);
        this.currentStep = step;
        this.fireChangeEvent();
    }

    public void stepEnd(String warningMessage) {
        this.finishStep(JobStatusEnum.COMPLETED, warningMessage);
        this.fireChangeEvent();
    }

    public void stepStart(String stepName) {
        JobStep step = new JobStep();
        step.setStartDate(new Date());
        step.setProgresss(0);
        step.setStatus(JobStatusEnum.RUNNING);
        step.setStepName(stepName);
        step.setProcessor(null);
        step.setId(this.steps.size());
        this.steps.add(step);
        this.currentStep = step;
        this.fireChangeEvent();
    }

    public void stepError(String errorMessage) {
        this.finishStep(JobStatusEnum.FAILDED, errorMessage);
        this.fireChangeEvent();
    }

    private void finishStep(JobStatusEnum status, String message) {
        this.currentStep.setEndDate(new Date());
        this.currentStep.setStatus(this.isCanceled() ? JobStatusEnum.CANCELD : status);
        this.setCurStepProgress(100);
        this.currentStep.setErrorMessage(message);
        this.currentStep.setProcessor(null);
    }

    public void setCurStepProgress(int percentage) {
        this.currentStep.setProgresss(percentage);
        this.computeWholeProgress();
        this.fireChangeEvent();
    }

    public JobStep getStep(String stepName) {
        JobStep result = null;
        for (JobStep step : this.steps) {
            if (!StringUtils.equals((String)stepName, (String)step.getStepName())) continue;
            result = step;
            break;
        }
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public void buildStepInfo() {
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, this.steps);
            this.getJobEntity().setStepInfo(writer.toString());
        }
        catch (IOException e) {
            LOGGER.error((Object)"Can't serilize the job step");
        }
    }

    public JobEntity getJobEntity() {
        return this.jobEntity;
    }

    public void setJobEntity(JobEntity jobEntity) {
        this.jobEntity = jobEntity;
    }

    public long getId() {
        long result = -1L;
        if (this.jobEntity != null) {
            result = this.jobEntity.getId();
        }
        return result;
    }

    public void cancel() {
        this.isCanceled = true;
        this.getJobEntity().setEndDate(new Date());
        if (this.getCurrentStep() != null && this.getCurrentStep().getProcessor() != null) {
            this.getCurrentStep().getProcessor().cancel();
        }
        if (this.getJobEntity().getStatus() == JobStatusEnum.QUEUING) {
            this.setStatus(JobStatusEnum.CANCELD);
        }
    }

    public boolean isCancellable() {
        JobStep jobStep = this.getCurrentStep();
        if (jobStep == null || jobStep.getProcessor() == null) {
            return true;
        }
        boolean isCriticalStep = StringUtils.contains((String)this.criticalStepNames, (String)jobStep.getStepName());
        if (isCriticalStep) {
            return false;
        }
        AbstractManageableProcessor currentProcessor = jobStep.getProcessor();
        boolean isPluginProcessor = currentProcessor instanceof AbstractPluginProcessor;
        if (!isPluginProcessor) {
            return true;
        }
        return ((AbstractPluginProcessor)currentProcessor).getPluginExecutor().isCancellable();
    }

    private void computeWholeProgress() {
        for (JobStepWeight stepWeight : this.stepWeights) {
            if (!StringUtils.equals((String)stepWeight.getStepName(), (String)this.currentStep.getStepName())) continue;
            this.setProgress(stepWeight.getCurrentProgress() + (int)((float)(stepWeight.getWeight() * this.currentStep.getProgresss()) / 100.0f));
            break;
        }
    }

    private void fireChangeEvent() {
        if (this.handlers == null) {
            return;
        }
        for (JobStatusChangeHandler handler : this.handlers) {
            handler.onChange(this);
        }
    }

    public void setProgress(int totalProgress) {
        this.progresss = totalProgress;
        this.fireChangeEvent();
    }

    public void setStatus(JobStatusEnum status) {
        if (status != this.jobEntity.getStatus()) {
            this.jobEntity.setStatus(status);
            this.fireChangeEvent();
        }
    }

    public int getProgress() {
        return this.progresss;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public List<MessageEntry> getMessages() {
        return this.messages;
    }

    public Task getTask() {
        return this.task;
    }

    public void setStepWeight(List<JobStepWeight> stepWeights) {
        this.stepWeights = stepWeights;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public List<JobStatusChangeHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<JobStatusChangeHandler> handlers) {
        this.handlers = handlers;
    }

    public void setCriticalStepNames(String criticalStepNames) {
        this.criticalStepNames = criticalStepNames;
    }
}

