/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.accessor.JobDataMapAccessor;
import com.ericsson.cms.epgmgmt.cluster.data.JobStatusData;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.handler.JobStatusChangeHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultJobStatusChangeHandler
implements JobStatusChangeHandler {
    private JobDataMapAccessor accessor;
    private HazelcastManager hazelcastManager;

    @Override
    public void onChange(Job job) {
        if (this.hazelcastManager.isActive() && this.canPublish(job)) {
            this.accessor.publishJobStatus(new JobStatusData(job, this.hazelcastManager.getLocalServer()));
        }
    }

    private boolean canPublish(Job job) {
        JobStatusData jsd = this.accessor.getJobStatus(job.getTask().getId());
        if (jsd == null || !this.hazelcastManager.isRemoteSeverWork(jsd.getMember()) || this.hazelcastManager.getLocalServer().equals(jsd.getMember())) {
            return true;
        }
        JobStatusEnum status = jsd.getJobStatus();
        return job.getJobEntity().getStatus() == JobStatusEnum.RUNNING || status != JobStatusEnum.RUNNING;
    }

    @Autowired
    public void setJobStatusMapAccessor(JobDataMapAccessor accessor) {
        this.accessor = accessor;
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }
}

