/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class IngestJobFollowingIngestion
implements PostEventHandler {
    private ITaskManager taskManager;
    private ITaskJobExecutor jobExecutor;

    @Override
    public void afterJobDone(IJob job) {
        boolean isNotCompleted;
        boolean isNotIngestJob = job.getJobEntity().getType() != TaskTypeEnum.INGEST;
        boolean bl = isNotCompleted = job.getJobEntity().getStatus() != JobStatusEnum.COMPLETED;
        if (isNotIngestJob || isNotCompleted) {
            return;
        }
        Task current = job.getTask();
        List followingIngestTaskList = this.taskManager.getFollowingIngestionList(current);
        for (Task ingestTask : followingIngestTaskList) {
            if (!ingestTask.isEnabled() || !ingestTask.isManual()) continue;
            this.jobExecutor.startTask(ingestTask);
        }
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }
}

