/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class IngestJobSubscriber
implements PostEventHandler {
    private ITaskManager taskManager;
    private ITaskJobExecutor jobExecutor;

    @Override
    public void afterJobDone(IJob job) {
        boolean isNotCompleted;
        boolean isNotIngestJob = job.getJobEntity().getType() != TaskTypeEnum.INGEST;
        boolean bl = isNotCompleted = job.getJobEntity().getStatus() != JobStatusEnum.COMPLETED;
        if (isNotIngestJob || isNotCompleted) {
            return;
        }
        Task ingestTask = job.getTask();
        List exportTasks = this.taskManager.getSubscribers(ingestTask);
        for (Task exportTask : exportTasks) {
            if (!exportTask.isEnabled() || !exportTask.isManual()) continue;
            this.jobExecutor.startTask(exportTask);
        }
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setJobExecutor(ITaskJobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }
}

