/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.email.EmailContentProvider;
import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.email.MessageEntryFilter;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.IMailService;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.util.MailUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class JobEmailNotifier
implements PostEventHandler {
    public static final String KEY_EMAIL_MESSAGE_LIST = "email.message.list";
    private IMailService mailService;
    private IPartnerManager partnerManager;
    private EmailContentProvider emailContentProvider;
    private MessageEntryFilter messageEntryFilter;

    @Override
    public void afterJobDone(IJob job) {
        Partner partner = this.getPartner(job);
        if (partner == null || !partner.isAlert()) {
            return;
        }
        List<MessageEntry> messages = ((Job)job).getMessages();
        if (messages == null || messages.isEmpty()) {
            return;
        }
        List<MessageEntry> targetMessage = this.messageEntryFilter.filter(messages);
        if (targetMessage.isEmpty()) {
            return;
        }
        EmailAlertLevelEnum emailLevel = this.messageEntryFilter.getTopLevel(targetMessage);
        this.mailService.sendEmail(MailUtil.extractEmailAddress(partner.getEmail()), this.emailContentProvider.getEmailSubject(partner, emailLevel), this.emailContentProvider.getEmailContent(targetMessage));
    }

    private Partner getPartner(IJob job) {
        return this.partnerManager.getPartner(job.getJobEntity().getPartnerId());
    }

    @Autowired
    public void setMailService(IMailService mailService) {
        this.mailService = mailService;
    }

    @Autowired
    public void setEmailContentProvider(EmailContentProvider emailContentProvider) {
        this.emailContentProvider = emailContentProvider;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }

    @Autowired
    public void setMessageEntryFilter(MessageEntryFilter messageEntryFilter) {
        this.messageEntryFilter = messageEntryFilter;
    }
}

