/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.accessor.JobDataMapAccessor;
import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.entitymanager.JobTraceManager;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.service.IJob;
import org.springframework.beans.factory.annotation.Autowired;

public class JobStatusEraser
implements PostEventHandler {
    private JobDataMapAccessor jobDataMapAccessor;
    private HazelcastManager hazelcastManager;
    private JobTraceManager jobTraceManager;

    @Override
    public void afterJobDone(IJob job) {
        if (job.getId() > 0L && job.getContext().get("marked.for.recovery") == null) {
            this.jobTraceManager.finishJobTrace(job.getId());
        }
        if (this.hazelcastManager.isActive()) {
            this.jobDataMapAccessor.eraseJobStatus(job.getTask().getId());
            if (job.getTask().getTriggerType() == TaskTriggerTypeEnum.MANUAL) {
                this.hazelcastManager.releaseToken(KeyUtil.getJobTokenKey(job.getTask().getId(), null));
            }
        }
    }

    @Autowired
    public void setJobDataMapAccessor(JobDataMapAccessor jobDataMapAccessor) {
        this.jobDataMapAccessor = jobDataMapAccessor;
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }

    @Autowired
    public void setJobTraceManager(JobTraceManager jobTraceManager) {
        this.jobTraceManager = jobTraceManager;
    }
}

