/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.handler;

import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.Partner;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.PostEventHandler;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.TaskJobScheduler;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class RetryJobHandler
implements PostEventHandler {
    private IAlarmActivityLogManager activityLog;
    private TaskJobScheduler jobScheduler;

    @Override
    public void afterJobDone(IJob ijob) {
        Job job = (Job)ijob;
        Endpoint endpoint = job.getTask().getEndpoint();
        Boolean lackFile = (Boolean)job.getContext().get("Lack_File");
        if (lackFile != Boolean.TRUE || endpoint.getRetryCount() <= 0 || endpoint.getRetryDelay() <= 0L || job.getTask().getTriggerType() == TaskTriggerTypeEnum.MANUAL) {
            return;
        }
        Integer retried = (Integer)job.getContext().get("Retry_Count");
        if (retried == null) {
            retried = 0;
        }
        Partner partner = job.getTask().getPartner();
        if (endpoint.getRetryCount() <= retried) {
            String message = ApplicationContextUtil.getMessage((String)"task.exceed.retry.and.canceled", (Object[])new Object[]{job.getTask().getName(), retried});
            this.activityLog.log(PluginLogSeverity.WARNING, PluginLogComponent.INGEST, message, partner.getId(), partner.getPartnerType().toString());
        } else {
            Date triggerDate = (Date)job.getContext().get("first.trigger.time");
            Calendar firstTriggerCal = Calendar.getInstance();
            firstTriggerCal.setTime(triggerDate);
            Calendar cal = Calendar.getInstance();
            cal.add(12, (int)endpoint.getRetryDelay());
            if (cal.get(6) == firstTriggerCal.get(6) && cal.get(1) == firstTriggerCal.get(1)) {
                Map<String, Object> params = job.getContext();
                params.put("Retry_Count", retried + 1);
                this.jobScheduler.scheduleOnceTask(job.getTask(), cal.getTime(), params);
                String message = String.format("Retry task[%s] after %d minutes.", job.getTask().getName(), endpoint.getRetryDelay());
                this.activityLog.log(PluginLogSeverity.INFORMATION, PluginLogComponent.INGEST, message, partner.getId(), partner.getPartnerType().toString());
            }
        }
    }

    @Autowired
    public void setActivityLog(IAlarmActivityLogManager activityLog) {
        this.activityLog = activityLog;
    }

    @Autowired
    public void setJobScheduler(TaskJobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }
}

