/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.recovery;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.cluster.accessor.JobDataMapAccessor;
import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import com.ericsson.cms.epgmgmt.dto.JobCommentsDto;
import com.ericsson.cms.epgmgmt.entity.JobEntity;
import com.ericsson.cms.epgmgmt.entity.JobTrace;
import com.ericsson.cms.epgmgmt.entity.enumeration.JobStatusEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.job.recovery.JobRecoverer;
import com.ericsson.cms.epgmgmt.job.recovery.RecoverJobChecker;
import com.ericsson.cms.epgmgmt.service.IJobManager;
import com.ericsson.cms.epgmgmt.service.IJobTraceManager;
import com.ericsson.cms.epgmgmt.service.ITaskJobExecutor;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.utility.json.JsonUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobRecoverer
implements JobRecoverer {
    private ITaskJobExecutor taskJobExecutor;
    private ITaskManager taskManager;
    private IJobManager jobManager;
    private IJobTraceManager jobTraceManager;
    private RecoverJobChecker recoverJobChecker;
    private HazelcastManager hazelcastManager;
    private JobDataMapAccessor jobDataMapAccessor;

    protected void finishedFailureJob(JobTrace jobTrace) throws Exception {
        JobEntity je = jobTrace.getJob();
        if (je.getStatus() == JobStatusEnum.RUNNING) {
            je.setStatus(JobStatusEnum.FAILDED);
            JobCommentsDto comments = new JobCommentsDto();
            if (StringUtils.isNotBlank((String)je.getComments())) {
                comments = (JobCommentsDto)JsonUtil.readObject((String)je.getComments(), JobCommentsDto.class);
            }
            comments.setComments("job.comments.fail.reason.unknown");
            je.setComments(JsonUtil.writeValue((Object)comments));
            this.getJobManager().update(je);
        }
        jobTrace.setFinished(true);
        this.getJobDataMapAccessor().eraseJobStatus(je.getTaskId());
        this.getJobTraceManager().updateJobTrace(jobTrace);
        this.cleanSelfToken(KeyUtil.getJobTokenKey(je.getTaskId(), je.getTriggerType() == TaskTriggerTypeEnum.MANUAL ? null : je.getTriggerDate()));
        this.cleanSelfToken(KeyUtil.getJobPartnerTokenKey(String.valueOf(je.getPartnerId())));
    }

    private void cleanSelfToken(String tokenKey) {
        Object node = this.hazelcastManager.getTokenMap().get((Object)tokenKey);
        if (node != null && (node == this.hazelcastManager.getLocalServer() || node.equals(this.hazelcastManager.getLocalServer()))) {
            this.hazelcastManager.releaseToken(tokenKey);
        }
    }

    public ITaskJobExecutor getTaskJobExecutor() {
        return this.taskJobExecutor;
    }

    @Autowired
    public void setTaskJobExecutor(ITaskJobExecutor taskJobExecutor) {
        this.taskJobExecutor = taskJobExecutor;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public IJobManager getJobManager() {
        return this.jobManager;
    }

    @Autowired
    public void setJobManager(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    public IJobTraceManager getJobTraceManager() {
        return this.jobTraceManager;
    }

    @Autowired
    public void setJobTraceManager(IJobTraceManager jobTraceManager) {
        this.jobTraceManager = jobTraceManager;
    }

    public RecoverJobChecker getRecoverJobChecker() {
        return this.recoverJobChecker;
    }

    @Autowired
    public void setRecoverJobChecker(RecoverJobChecker recoverJobChecker) {
        this.recoverJobChecker = recoverJobChecker;
    }

    public HazelcastManager getHazelcastManager() {
        return this.hazelcastManager;
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }

    public JobDataMapAccessor getJobDataMapAccessor() {
        return this.jobDataMapAccessor;
    }

    @Autowired
    public void setJobDataMapAccessor(JobDataMapAccessor jobDataMapAccessor) {
        this.jobDataMapAccessor = jobDataMapAccessor;
    }
}

