/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.recovery;

import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import com.ericsson.cms.epgmgmt.entity.JobTrace;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.job.recovery.AbstractJobRecoverer;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DefaultJobRecoverer
extends AbstractJobRecoverer {
    private static Logger logger = Logger.getLogger(DefaultJobRecoverer.class);

    @Override
    public int recover() {
        try {
            InetSocketAddress address = this.getHazelcastManager().getLocalServer().getInetSocketAddress();
            JobTrace jobTrace = this.getJobTraceManager().getJobTrace(address.getAddress().getHostAddress(), address.getPort());
            if (jobTrace == null || jobTrace.isFinished()) {
                return 0;
            }
            logger.info((Object)("Job[" + jobTrace.getJob().getId() + "] has fail for unknown reason."));
            this.finishedFailureJob(jobTrace);
            if (!this.getRecoverJobChecker().shouldRecover(jobTrace.getJob())) {
                return 0;
            }
            int recovered = 0;
            if (this.getHazelcastManager().acquireToken(KeyUtil.getJobRecoverKey(jobTrace.getJobId()))) {
                logger.info((Object)("Recovering Job[" + jobTrace.getJob().getId() + "]"));
                Task task = this.getTaskManager().getTask(jobTrace.getJob().getTaskId());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("trigger.time", new Date());
                params.put("comments", "job.comments.recovery.from.failure");
                params.put("recovered.from", jobTrace.getJobId());
                this.getTaskJobExecutor().startTask(task, params);
                ++recovered;
            }
            return recovered;
        }
        catch (Exception e) {
            logger.warn((Object)"Error happen while recovering job", (Throwable)e);
            return 0;
        }
    }
}

