/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.recovery;

import com.ericsson.cms.epgmgmt.entity.JobEntity;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTriggerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.job.JobDto;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class RecoverJobChecker {
    private static final int SECONDS_IN_A_DAY = 86400;
    private ITaskManager taskManager;

    private boolean isInputRemote(EndpointSchemeEnum endpointType) {
        return endpointType == EndpointSchemeEnum.ftp || endpointType == EndpointSchemeEnum.sftp;
    }

    private boolean isTriggerTypeNeedRecover(TaskTriggerTypeEnum type, String triggerValue) {
        return type == TaskTriggerTypeEnum.MANUAL || type == TaskTriggerTypeEnum.SCHEDULE || type == TaskTriggerTypeEnum.FREQUENCY && Integer.valueOf(triggerValue) >= 86400;
    }

    public boolean shouldRecover(JobEntity job) {
        JobDto dto = new JobDto();
        dto.setTaskId(job.getTaskId()).setType(job.getType()).setStart(job.getStartDate());
        return this.shouldRecover(dto);
    }

    public boolean shouldRecover(JobDto job) {
        if (job == null) {
            return false;
        }
        Task t = this.taskManager.getTask(job.getTaskId());
        if (t == null || !t.isEnabled()) {
            return false;
        }
        return (job.getType() == TaskTypeEnum.EXPORT || this.isInputRemote(t.getEndpoint().getEndpointType())) && this.isTriggerTypeNeedRecover(t.getTriggerType(), t.getTriggerValue()) && CalendarUtil.isSameDay((Date)job.getStart());
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }
}

