/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.job.recovery;

import com.ericsson.cms.epgmgmt.cluster.util.KeyUtil;
import com.ericsson.cms.epgmgmt.entity.JobTrace;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.job.recovery.AbstractJobRecoverer;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ScannerJobRecoverer
extends AbstractJobRecoverer
implements Runnable {
    private static final int DEFAULT_DOWNTIME_THRESHOLD = 1800000;
    private static final int WAIT_INTERVAL = 3000;
    private static Logger logger = Logger.getLogger(ScannerJobRecoverer.class);
    private int sleepTime = 3000;
    private int downTimeThreshold = 1800000;

    @Override
    public void run() {
        int recovered = this.recover();
        logger.info((Object)("Try to perform a recovery, " + recovered + " job(s) are recovered."));
    }

    @Override
    public int recover() {
        List unfinishedJobs = this.getJobTraceManager().getUnfinishedJobs();
        int recovered = 0;
        for (JobTrace jt : unfinishedJobs) {
            try {
                if (this.remoteNodeIsUp(jt.getNodeAddress(), jt.getNodePort()) || !this.downtimeExceedThreshold(jt)) continue;
                logger.info((Object)("Job[" + jt.getJob().getId() + "] has fail for unknown reason."));
                this.finishedFailureJob(jt);
                if (!this.getRecoverJobChecker().shouldRecover(jt.getJob()) || !this.getHazelcastManager().acquireToken(KeyUtil.getJobRecoverKey(jt.getJobId()))) continue;
                logger.info((Object)("Taking over the unfinished job[" + jt.getJob().getId() + "] from [" + jt.getNodeAddress() + "]"));
                Task task = this.getTaskManager().getTask(jt.getJob().getTaskId());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("trigger.time", new Date());
                params.put("comments", "job.comments.recovery.takeover");
                params.put("recovered.from", jt.getJobId());
                this.getTaskJobExecutor().startTask(task, params);
                ++recovered;
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot recover job [" + jt + "]"), (Throwable)e);
            }
        }
        return recovered;
    }

    private boolean downtimeExceedThreshold(JobTrace jt) {
        return Calendar.getInstance().getTimeInMillis() - jt.getStartTime().getTime() > (long)this.downTimeThreshold;
    }

    private boolean remoteNodeIsUp(String ip, int port) {
        if (StringUtils.isBlank((String)ip)) {
            return false;
        }
        int count = 5;
        while (count > 0) {
            if (this.getHazelcastManager().isRemoteServerUp(ip, port)) {
                return true;
            }
            --count;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {}
        }
        logger.info((Object)("node[" + ip + "] is down."));
        return false;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setDownTimeThreshold(int downTimeThreshold) {
        this.downTimeThreshold = downTimeThreshold;
    }
}

