/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.normalizationrules;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.Publisher;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationGroupComparator;
import com.ericsson.cms.epgmgmt.entity.rule.NormalizationRule;
import com.ericsson.cms.epgmgmt.exception.NormalizationRuleException;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.normalizationrules.IEPGRulesNormalizer;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.INormalizationGroupManager;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class EPGRulesNormalizer
extends AbstractManageableProcessor
implements IEPGRulesNormalizer {
    private static final String NORMALIZATION_RULE_APPLY_FAILURE = "Applying normalization rules on %s - normalization rule %s failed.";
    private static final String DEBUG_INFO_FOR_RULE_APPLY = "applyProviderNormalizationRules(long) - Applying normalization rule on %s - normalization rule %s, query generate - %s.";
    private static final String COMPLETE_RULES_APPLY = "Applying normalization rules on  %s - completed applying normalization rules from group %s.";
    private static final String START_RULES_APPLY = "Applying normalization rules on %s - started applying normalization rules from group %s.";
    private static final String NO_RULES_CONFIGED_UNDER_GROUP = "Applying normalization rules on %s - no rules configured for normalization rule group %s.";
    private static final String GROUP_IS_NOT_ENABLED = "Applying normalization rules on %s - normalization rule group, %s,  is not enabled.";
    private static final String NO_PUBLISHER_FOUND = "Applying normalization rules on epg receiver %d - no receiver found in database.";
    private static final String ERRORS_DURING_RULES_APPLY = "Applying normalization rules on %s - error found while applying normalization rules. error message - %s.";
    private static final String NO_NORMALIZATION_GROUPS_CONFIGURED_OR_ENABLED = "Applying normalization rules on %s - no normalization rule groups either configured or enabled.";
    private static final String NO_PROVIDER_FOUND = "Applying normalization rules on epg provider %d - no provider found in database.";
    private static Log logger = LogFactory.getLog(EPGRulesNormalizer.class);
    private IAlarmActivityLogManager applicationLogger;
    private IPartnerManager partnerManager;
    private INormalizationGroupManager normalizationGroupManager;
    @Autowired
    @Qualifier(value="h2JdbcTemplate")
    private JdbcTemplate jdbcTemplate;

    @Override
    protected void innerProcess(Exchange exchange) {
        if (this.isIngest()) {
            this.applyProviderNormalizationRules(this.getPartnerId());
        } else {
            this.applyPublisherNormalizationRules(this.getPartnerId());
        }
    }

    @Override
    @Transactional
    public void applyProviderNormalizationRules(long providerId) throws NormalizationRuleException {
        logger.debug((Object)"applyProviderNormalizationRules(long) - start");
        Provider provider = this.partnerManager.getProvider(providerId);
        if (provider == null) {
            this.addWarningLogs(String.format(NO_PROVIDER_FOUND, providerId), -1L, PartnerTypeEnum.Provider.toString());
            return;
        }
        List<NormalizationGroup> normalizationGrps = this.getNormalizationGroupsForProvider(provider);
        if (normalizationGrps.size() == 0) {
            this.addWarningLogs(String.format(NO_NORMALIZATION_GROUPS_CONFIGURED_OR_ENABLED, provider.toString()), providerId, PartnerTypeEnum.Provider.toString());
            return;
        }
        try {
            this.checkCancel();
            this.setProgress(20);
            this.applyNormalizationGroups(false, provider.toString(), normalizationGrps, providerId);
        }
        catch (Exception ex) {
            this.addErrorLogs(String.format(ERRORS_DURING_RULES_APPLY, provider.toString(), ex.getMessage()), providerId, PartnerTypeEnum.Provider.toString());
            throw new NormalizationRuleException(ex.getMessage(), (Throwable)ex);
        }
        logger.debug((Object)"applyProviderNormalizationRules(long) - end");
    }

    @Override
    @Transactional
    public void applyPublisherNormalizationRules(long publisherId) {
        logger.debug((Object)"applyPublisherNormalizationRules(long) - start");
        Publisher publisher = this.partnerManager.getPublisher(publisherId);
        if (publisher == null) {
            this.addWarningLogs(String.format(NO_PUBLISHER_FOUND, publisherId), -1L, PartnerTypeEnum.Receiver.toString());
            return;
        }
        List<NormalizationGroup> normalizationGrps = this.getNormalizationGroupsForPublisher(publisher);
        if (normalizationGrps.size() == 0) {
            this.addWarningLogs(String.format(NO_NORMALIZATION_GROUPS_CONFIGURED_OR_ENABLED, publisher.toString()), publisherId, PartnerTypeEnum.Receiver.toString());
            return;
        }
        try {
            this.applyNormalizationGroups(true, publisher.toString(), normalizationGrps, publisherId);
        }
        catch (Exception ex) {
            this.addErrorLogs(String.format(ERRORS_DURING_RULES_APPLY, publisher.toString(), ex.getMessage()), publisherId, PartnerTypeEnum.Receiver.toString());
            throw new NormalizationRuleException(ex.getMessage(), (Throwable)ex);
        }
        logger.debug((Object)"applyPublisherNormalizationRules(long) - end");
    }

    private void applyNormalizationGroups(boolean isPublisher, String name, List<NormalizationGroup> normalizationGrps, long sourceId) {
        Collections.sort(normalizationGrps, new NormalizationGroupComparator());
        int step = (isPublisher ? 100 : 80) / normalizationGrps.size();
        int from = isPublisher ? 0 : 20;
        for (int i = 0; i < normalizationGrps.size(); ++i) {
            this.applyNormalizationGroup(isPublisher, name, normalizationGrps.get(i), sourceId);
            this.setProgress(from + step * (i + 1));
        }
    }

    private void applyNormalizationGroup(boolean isPublisher, String name, NormalizationGroup nGrp, long sourceId) {
        String sourceType;
        String groupName = nGrp.getName();
        String string = sourceType = isPublisher ? PartnerTypeEnum.Receiver.toString() : PartnerTypeEnum.Provider.toString();
        if (!nGrp.getEnabled().booleanValue()) {
            this.addInfoLogs(String.format(GROUP_IS_NOT_ENABLED, name, groupName), sourceId, sourceType);
            return;
        }
        List normalizationRules = nGrp.getRules();
        if (CollectionUtils.isEmpty((Collection)normalizationRules)) {
            this.addInfoLogs(String.format(NO_RULES_CONFIGED_UNDER_GROUP, name, groupName), sourceId, sourceType);
            return;
        }
        this.addInfoLogs(String.format(START_RULES_APPLY, name, groupName), sourceId, sourceType);
        for (NormalizationRule nRule : normalizationRules) {
            this.checkCancel();
            this.applyNormalizationRule(isPublisher, name, nRule, sourceId);
        }
        this.addInfoLogs(String.format(COMPLETE_RULES_APPLY, name, groupName), sourceId, sourceType);
    }

    private void applyNormalizationRule(boolean isPublisher, String name, NormalizationRule nRule, long sourceId) {
        block2: {
            String normalizationQuery = null;
            String sourceType = isPublisher ? PartnerTypeEnum.Receiver.toString() : PartnerTypeEnum.Provider.toString();
            try {
                normalizationQuery = nRule.getRuleAsSqlString(isPublisher);
                logger.debug((Object)String.format(DEBUG_INFO_FOR_RULE_APPLY, name, nRule.getName(), normalizationQuery));
                this.jdbcTemplate.update(normalizationQuery);
            }
            catch (RuntimeException rtEx) {
                String errorMsg = String.format(NORMALIZATION_RULE_APPLY_FAILURE, name, nRule.getName());
                this.addErrorLogs(errorMsg, sourceId, sourceType);
                if (normalizationQuery == null) break block2;
                logger.error((Object)String.format(" Generated SQL - %s", normalizationQuery));
            }
        }
    }

    private void addInfoLogs(String msg, long sourceId, String sourceType) {
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.NORMALIZATION_RULES, msg, sourceId, sourceType);
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.INFO, "", msg, PluginLogComponent.NORMALIZATION_RULES));
    }

    private void addWarningLogs(String msg, long sourceId, String sourceType) {
        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.NORMALIZATION_RULES, msg, sourceId, sourceType);
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.WARNING, "", msg, PluginLogComponent.NORMALIZATION_RULES));
    }

    private void addErrorLogs(String msg, long sourceId, String sourceType) {
        this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.NORMALIZATION_RULES, msg, sourceId, sourceType);
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.ERROR, "", msg, PluginLogComponent.NORMALIZATION_RULES));
    }

    private List<NormalizationGroup> getNormalizationGroupsForProvider(Provider provider) {
        ArrayList<NormalizationGroup> normalizationGrps = new ArrayList<NormalizationGroup>();
        normalizationGrps.addAll(provider.getNormalizationGroups());
        normalizationGrps.addAll(this.normalizationGroupManager.getAllGlobalForProviders());
        return normalizationGrps;
    }

    private List<NormalizationGroup> getNormalizationGroupsForPublisher(Publisher publisher) {
        ArrayList<NormalizationGroup> normalizationGrps = new ArrayList<NormalizationGroup>();
        normalizationGrps.addAll(publisher.getNormalizationGroups());
        normalizationGrps.addAll(this.normalizationGroupManager.getAllGlobalForPublishers());
        return normalizationGrps;
    }

    @Autowired
    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }

    @Autowired
    public void setNormalizationGroupManager(INormalizationGroupManager normalizationGroupManager) {
        this.normalizationGroupManager = normalizationGroupManager;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void cancel() {
        super.cancel();
    }
}

