/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.cluster.HazelcastManager;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyEntity;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyValue;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EPGPluginTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.plugin.IEPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IPluginPropertyManager;
import com.ericsson.cms.epgmgmt.utility.misc.EpgFormatUtil;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.ManagementFeature;
import com.ericsson.epgmgr.plugin.PluginAttribute;
import com.ericsson.epgmgr.plugin.PluginProperty;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EPGPluginManager
implements IEPGPluginManager {
    private static Log logger = LogFactory.getLog(EPGPluginManager.class);
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String DEFAULT_INSTALLATION_FOLDER = System.getProperty("com.tandbergtv.cms.product.dir") + FILE_SEPARATOR + "plugins" + FILE_SEPARATOR + "epgmgmt";
    private String installationFolder;
    private HazelcastManager hazelcastManager;
    private IPluginPropertyManager pluginPropertyManger;
    private IEPGMetadataManager epgMetadataManager;
    private IAlarmActivityLogManager applicationLogger;
    private List<String> pluginFrameworkVersions;
    private static final String PLUGIN_FRAMEWORK_VERSION = "3.0";
    private boolean hasFolderError = true;
    private boolean multipleVersionsSupport;
    private final Map<String, Map<String, List<AbstractMap.SimpleEntry<String, File>>>> pluginRepositoy = new HashMap<String, Map<String, List<AbstractMap.SimpleEntry<String, File>>>>();

    @PostConstruct
    public void start() {
        if (!this.hasFolderError) {
            this.checkPluginsInSystem();
            this.autoInstallPlugin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoInstallPlugin() {
        List listOfFiles = (List)FileUtils.listFiles((File)new File(this.installationFolder), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".jar"), (IOFileFilter)TrueFileFilter.INSTANCE);
        String key = this.getClass().getName();
        try {
            boolean can = this.hazelcastManager.acquireToken(key, 7200L);
            if (!can) {
                logger.error((Object)String.format("Faild to get the hazelcast key '%s'", key));
                return;
            }
            for (File file : listOfFiles) {
                IEPGManagerPlugin plugin = this.findPluginInFile(file);
                if (plugin == null || !this.validateVersion(plugin)) continue;
                this.addPluginInfo(plugin, file);
            }
            for (String type : this.pluginRepositoy.keySet()) {
                Map<String, List<AbstractMap.SimpleEntry<String, File>>> pluginsWithType = this.pluginRepositoy.get(type);
                for (String format : pluginsWithType.keySet()) {
                    List<AbstractMap.SimpleEntry<String, File>> pluginsWithVersion = pluginsWithType.get(format);
                    for (AbstractMap.SimpleEntry<String, File> plugin : pluginsWithVersion) {
                        File jarFile;
                        String version = plugin.getKey();
                        boolean needInstall = this.needLoadPlugin(type, format, version, jarFile = plugin.getValue());
                        if (!needInstall) continue;
                        this.installPlugin(jarFile);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Errors occur during the plugin installation: " + e.getMessage()));
        }
        finally {
            this.hazelcastManager.releaseToken(key);
        }
    }

    private void checkPluginsInSystem() {
        List formats = this.epgMetadataManager.getAllEpgFormatDetails();
        if (formats == null || formats.size() == 0) {
            return;
        }
        for (EpgFormat format : formats) {
            File file = new File(format.getJarName());
            if (format.isDeleted() || file.exists()) continue;
            String errMsg = String.format("The jar file for plugin %s does not exists: %s", format.getId(), format.getJarName());
            logger.error((Object)errMsg);
            this.uninstallPlugin(format);
        }
    }

    private boolean needLoadPlugin(String type, String formatName, String version, File file) {
        String id = String.format("%s_%s_%s", type, formatName, version);
        EpgFormat pluginFormat = this.epgMetadataManager.getEpgFormatDetailsbyId(id);
        if (pluginFormat != null) {
            long recordDate = pluginFormat.getUpdateDate().getTime();
            return pluginFormat.isDeleted() || file.lastModified() > recordDate;
        }
        if (this.multipleVersionsSupport) {
            return true;
        }
        List<EpgFormat> pluginsWithName = this.getNotDeletedFormats(type, formatName);
        if (pluginsWithName.size() != 0) {
            String errMsg = String.format("Do not install the plugin %s since there are plugins with the same name in the system:%s", file.getAbsolutePath(), pluginsWithName.toString());
            logger.error((Object)errMsg);
            return false;
        }
        return true;
    }

    private List<EpgFormat> getNotDeletedFormats(String type, String name) {
        List formats = this.epgMetadataManager.getAllEpgFormatDetails();
        if (formats == null) {
            return new ArrayList<EpgFormat>();
        }
        ArrayList<EpgFormat> matchFormats = new ArrayList<EpgFormat>(formats.size());
        for (EpgFormat format : formats) {
            if (format.isDeleted() || !format.getType().equals(type) || !format.getFormatName().equals(name)) continue;
            matchFormats.add(format);
        }
        return matchFormats;
    }

    private IEPGManagerPlugin findPluginInFile(File file) {
        logger.debug((Object)("Looking in " + file.getAbsolutePath() + " for provider plugin"));
        IEPGManagerProvider epgPlugin = null;
        try {
            epgPlugin = PluginFactory.getProviderPlugin(file);
        }
        catch (Exception ex) {
            logger.warn((Object)("Found a version does not support. Ignore this plugin: " + file.getAbsolutePath()), (Throwable)ex);
        }
        if (epgPlugin != null) {
            logger.debug((Object)("Find a provider plugin in " + file.getAbsolutePath()));
            return epgPlugin;
        }
        try {
            epgPlugin = PluginFactory.getPublisherPlugin(file);
        }
        catch (Exception ex) {
            logger.warn((Object)("Found a version does not support. Ignore this plugin: " + file.getAbsolutePath()), (Throwable)ex);
        }
        if (epgPlugin != null) {
            logger.debug((Object)("Find a publisher plugin in " + file.getAbsolutePath()));
        }
        return epgPlugin;
    }

    public void installPlugin(File file) {
        logger.debug((Object)("Looking in " + file.getAbsolutePath() + " for provider plugin"));
        IEPGManagerProvider providerPlugin = null;
        try {
            providerPlugin = PluginFactory.getProviderPlugin(file);
        }
        catch (Exception ex) {
            logger.warn((Object)("Found a version does not support. Ignore this plugin: " + file.getAbsolutePath()), (Throwable)ex);
        }
        this.loadPlugin(file, (IEPGManagerPlugin)providerPlugin);
        if (providerPlugin != null) {
            return;
        }
        logger.debug((Object)("Looking in " + file.getAbsolutePath() + " for publisher plugin"));
        IEPGManagerPublisher publisherPlugin = null;
        try {
            publisherPlugin = PluginFactory.getPublisherPlugin(file);
        }
        catch (Exception ex) {
            logger.warn((Object)("Found a version does not support. Ignore this plugin: " + file.getAbsolutePath()), (Throwable)ex);
        }
        this.loadPlugin(file, (IEPGManagerPlugin)publisherPlugin);
    }

    private boolean validateVersion(IEPGManagerPlugin plugin) {
        boolean isValidate = false;
        if (plugin instanceof ManagementFeature) {
            String[] versions = ((ManagementFeature)plugin).getPluginFrameworkVersions();
            isValidate = !CollectionUtils.intersection(this.pluginFrameworkVersions, Arrays.asList(versions)).isEmpty();
        }
        return isValidate;
    }

    private void addPluginInfo(IEPGManagerPlugin plugin, File file) {
        String pluginType;
        String string = pluginType = plugin instanceof IEPGManagerProvider ? EPGPluginTypeEnum.Provider.toString() : EPGPluginTypeEnum.Publisher.toString();
        if (!this.pluginRepositoy.containsKey(pluginType)) {
            this.pluginRepositoy.put(pluginType, new HashMap());
        }
        String formatName = plugin.getFormat();
        Map<String, List<AbstractMap.SimpleEntry<String, File>>> pluginsWithType = this.pluginRepositoy.get(pluginType);
        if (!pluginsWithType.containsKey(plugin.getFormat())) {
            pluginsWithType.put(formatName, new ArrayList());
        }
        List<AbstractMap.SimpleEntry<String, File>> pluginsWithFormat = pluginsWithType.get(formatName);
        String version = plugin.getVersion();
        if (this.multipleVersionsSupport) {
            pluginsWithFormat.add(new AbstractMap.SimpleEntry<String, File>(version, file));
        } else if (pluginsWithFormat.size() == 0) {
            pluginsWithFormat.add(new AbstractMap.SimpleEntry<String, File>(version, file));
        } else {
            AbstractMap.SimpleEntry<String, File> pluginWithVersion = pluginsWithFormat.get(0);
            String currentNewestVersion = pluginWithVersion.getKey();
            if (EPGPluginManager.compareVersion(version, currentNewestVersion) > 0) {
                pluginsWithFormat.remove(0);
                pluginsWithFormat.add(new AbstractMap.SimpleEntry<String, File>(version, file));
            }
        }
    }

    public static int compareVersion(String v1, String v2) {
        if ((v1 = v1.trim()).equals(v2 = v2.trim())) {
            return 0;
        }
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int i = 0;
        for (int j = 0; i < parts1.length && j < parts2.length; ++i, ++j) {
            int value2;
            int value1 = Integer.parseInt(parts1[i]);
            if (value1 == (value2 = Integer.parseInt(parts2[i]))) continue;
            return value1 - value2;
        }
        return parts1.length - parts2.length;
    }

    private void loadPlugin(File file, IEPGManagerPlugin plugin) {
        if (plugin == null) {
            logger.debug((Object)("EPG plugin not found in " + file.getAbsolutePath()));
            return;
        }
        if (!this.validateVersion(plugin)) {
            logger.warn((Object)String.format("The version of the plug-in (%s) is not supported by framework.", file.getAbsolutePath()));
            return;
        }
        String type = plugin instanceof IEPGManagerProvider ? EPGPluginTypeEnum.Provider.toString() : EPGPluginTypeEnum.Publisher.toString();
        try {
            ArrayList pluginProperties;
            logger.debug((Object)String.format("EPG %s plugin found in %s", type, file.getAbsolutePath()));
            String pluginFormat = plugin.getFormat();
            String pluginVersion = plugin.getVersion();
            String epgId = String.format("%s_%s_%s", type, pluginFormat, pluginVersion);
            EpgFormat epgFormat = new EpgFormat();
            epgFormat.setId(epgId);
            epgFormat.setJarName(file.getAbsolutePath());
            epgFormat.setFormatName(pluginFormat);
            epgFormat.setType(type);
            epgFormat.setVersion(pluginVersion);
            epgFormat.setInfo(EPGPluginManager.getPluginInfo(plugin));
            epgFormat.setDeleted(false);
            epgFormat.setActive(false);
            EpgFormat existingFormat = this.epgMetadataManager.getEpgFormatDetailsbyId(epgId);
            if (existingFormat != null) {
                epgFormat.setActive(existingFormat.isActive());
            }
            if ((pluginProperties = plugin.getProperties()) == null) {
                pluginProperties = new ArrayList();
            }
            Set pluginProps = PluginPropertyEntity.bulkCreate((EpgFormat)epgFormat, (List)pluginProperties);
            this.pluginPropertyManger.addPluginPropertyIfNotExists(pluginProps);
            this.epgMetadataManager.createOrUpdate(epgFormat);
            this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.PLUGIN_FRAMEWORK, "Installed plug-in " + epgFormat.toString());
        }
        catch (Exception ex) {
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, String.format("Error while installing EPG %s plug-in from %s", type, file.getAbsolutePath()));
            logger.error((Object)"exception found while initializing plugin ", (Throwable)ex);
        }
    }

    public List<EpgFormat> getAllConfiguredEpgFormats() {
        logger.debug((Object)"getAllConfiguredEpgFormats() - start");
        List result = null;
        try {
            result = this.epgMetadataManager.getAllEpgFormatDetails();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllConfiguredEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details, error message, " + ex.getMessage());
        }
        logger.debug((Object)"getAllConfiguredEpgFormats() - end");
        return result;
    }

    public List<EpgFormat> getAllProvidersEpgFormats() {
        logger.debug((Object)"getAllProvidersEpgFormats() - start");
        List result = null;
        try {
            result = this.epgMetadataManager.getAllProvidersEpgFormats();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllProvidersEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details of Providers, error message, " + ex.getMessage());
        }
        logger.debug((Object)"getAllProvidersEpgFormats() - end");
        return result;
    }

    public List<EpgFormat> getAllPublishersEpgFormats() {
        logger.debug((Object)"getAllPublishersEpgFormats() - start");
        List result = null;
        try {
            result = this.epgMetadataManager.getAllPublishersEpgFormats();
        }
        catch (Exception ex) {
            logger.error((Object)"getAllPublishersEpgFormats()", (Throwable)ex);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving EPGFormat details of Receivers, error message, " + ex.getMessage());
        }
        logger.debug((Object)"getAllPublishersEpgFormats() - end");
        return result;
    }

    public List<PluginProperty> getProperties(String formatId) throws EPGPluginException {
        EpgFormat epgFormat = null;
        List<Object> pluginProperty = null;
        try {
            pluginProperty = new ArrayList<PluginProperty>();
            epgFormat = this.epgMetadataManager.getEpgFormatDetailsbyId(formatId);
            if (epgFormat == null) {
                throw new Exception("no plug-in is registered for the given format Id" + formatId);
            }
            if (epgFormat.isETV() && !epgFormat.isProviderType()) {
                return pluginProperty;
            }
            if (epgFormat.isProviderType()) {
                IEPGManagerProvider epgProviderMgr = PluginFactory.getProviderPlugin(new File(epgFormat.getJarName()));
                if (epgProviderMgr == null) {
                    return pluginProperty;
                }
                pluginProperty = epgProviderMgr.getProperties();
            } else {
                IEPGManagerPublisher epgPublisherMgr = PluginFactory.getPublisherPlugin(new File(epgFormat.getJarName()));
                if (epgPublisherMgr == null) {
                    return pluginProperty;
                }
                pluginProperty = epgPublisherMgr.getProperties();
            }
        }
        catch (Exception epgEx) {
            logger.error((Object)"getProperties(long)", (Throwable)epgEx);
            String formatDtls = epgFormat == null ? formatId : epgFormat.toString();
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, "Error found while retrieving plug-in properties for EPG Format " + formatDtls + ", error message, " + epgEx.getMessage());
            throw new EPGPluginException("Error found while retrieving plug-in properties for EPG Format ID " + formatId + ", error message, " + epgEx.getMessage(), (Throwable)epgEx);
        }
        return pluginProperty;
    }

    public Map<String, Object> getFileNameAttribute(String formatId) throws EPGPluginException {
        try {
            IEPGManagerProvider epgProviderMgr;
            EpgFormat epgFormat = this.epgMetadataManager.getEpgFormatDetailsbyId(formatId);
            if (epgFormat == null) {
                throw new Exception("no plug-in is registered for the given format Id" + formatId);
            }
            if (epgFormat.isProviderType() && (epgProviderMgr = PluginFactory.getProviderPlugin(new File(epgFormat.getJarName()))) != null) {
                return epgProviderMgr.fileNameAttribute();
            }
        }
        catch (Exception epgEx) {
            logger.error((Object)"get plugin ingestionFileNameFormat failed.", (Throwable)epgEx);
        }
        return null;
    }

    public static String getPluginInfo(IEPGManagerPlugin plugin) {
        return EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.INFO);
    }

    private static String getPluginAttribute(IEPGManagerPlugin plugin, PluginAttribute attrib) {
        if (plugin == null || plugin.getAttributes() == null) {
            return null;
        }
        return (String)plugin.getAttributes().get(attrib);
    }

    public static String getPluginETVFormat(IEPGManagerPlugin plugin) {
        return EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.ETV_FORMAT);
    }

    public static boolean validateForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.VALIDATE));
    }

    public static boolean validationRuleForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.VALIDATIONRULE));
    }

    public static boolean nomalizationRuleForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.NORMALIZATIONRULE));
    }

    public static boolean mergeForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.MERGE));
    }

    public static boolean exportToStgForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.EXPORT_TO_STG));
    }

    public static boolean exportToXmlForPlugin(IEPGManagerPlugin plugin) {
        return !StringUtils.equalsIgnoreCase((String)"false", (String)EPGPluginManager.getPluginAttribute(plugin, PluginAttribute.EXPORT_TO_XML));
    }

    public List<PluginProperty> validateTaskProperties(Task task) throws EPGPluginException {
        IEPGManagerProvider epgProviderManager = PluginFactory.getProviderPlugin(task);
        List<PluginProperty> ppList = this.convertTaskPluginProperties(epgProviderManager.getProperties(), task);
        epgProviderManager.validateProperties(ppList);
        logger.debug((Object)"validateProviderProperties(List<PluginProperty>) - end");
        return ppList;
    }

    @Autowired
    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Autowired
    public void setEpgMetadataManager(IEPGMetadataManager epgMetadataManager) {
        this.epgMetadataManager = epgMetadataManager;
    }

    @Autowired
    public void setPluginPropertyManger(IPluginPropertyManager pluginPropertyManger) {
        this.pluginPropertyManger = pluginPropertyManger;
    }

    public List<PluginProperty> validateTaskPluginProperties(Task task) throws EPGPluginException {
        TaskTypeEnum taskType = task.getType();
        EpgFormat format = this.epgMetadataManager.getEpgFormat(task);
        if (taskType == TaskTypeEnum.EXPORT && format == null) {
            return Collections.emptyList();
        }
        IEPGManagerProvider plugin = null;
        File pluginJarFile = new File(format.getJarName());
        switch (taskType) {
            case INGEST: {
                plugin = PluginFactory.getProviderPlugin(pluginJarFile);
                break;
            }
            case EXPORT: {
                plugin = PluginFactory.getPublisherPlugin(pluginJarFile);
            }
        }
        List<PluginProperty> ppList = this.convertTaskPluginProperties(plugin.getProperties(), task);
        plugin.validateProperties(ppList);
        return ppList;
    }

    private List<PluginProperty> convertTaskPluginProperties(List<PluginProperty> ppList, Task task) {
        List<PluginPropertyValue> props = this.filterPluginProperties(task, task.getPluginPropertyValues());
        for (PluginProperty pluginProperty : ppList) {
            for (PluginPropertyValue ppv : props) {
                if (!pluginProperty.getName().equals(ppv.getPluginProperty().getPropertyName())) continue;
                pluginProperty.setConfiguredValue(ppv.getValue());
                break;
            }
            if (pluginProperty.getConfiguredValue() != null) continue;
            logger.info((Object)(" EPG Task " + task + " has a no value for property " + pluginProperty.getName() + ". use the default value :" + pluginProperty.getDefaultValue()));
            pluginProperty.setConfiguredValue(pluginProperty.getDefaultValue());
        }
        return ppList;
    }

    private List<PluginPropertyValue> filterPluginProperties(Task task, List<PluginPropertyValue> props) {
        EpgFormat format = this.epgMetadataManager.getEpgFormat(task);
        String currentFrameworkFormat = EpgFormatUtil.getFrameworkFormat((String)format.getId());
        ArrayList<PluginPropertyValue> result = new ArrayList<PluginPropertyValue>();
        for (PluginPropertyValue prop : props) {
            String id = prop.getPluginProperty().getId();
            String[] parts = id.split("_");
            String frameworkFormat = String.format("%s_%s", parts[0], parts[1]);
            if (!frameworkFormat.equals(currentFrameworkFormat)) continue;
            result.add(prop);
        }
        return result;
    }

    public static String getPluginFrameworkVersion() {
        return PLUGIN_FRAMEWORK_VERSION;
    }

    public void setPluginFrameworkVersions(List<String> pluginFrameworkVersions) {
        this.pluginFrameworkVersions = pluginFrameworkVersions;
    }

    @Autowired
    public void setHazelcastManager(HazelcastManager hazelcastManager) {
        this.hazelcastManager = hazelcastManager;
    }

    @Autowired
    public void setInstallationFolder(String installationFolder) {
        this.installationFolder = StringUtils.isBlank((String)installationFolder) ? DEFAULT_INSTALLATION_FOLDER : installationFolder;
        File folder = new File(installationFolder);
        this.hasFolderError = true;
        if (!folder.exists()) {
            String errMsg = "EPG Plugin Installation folder " + installationFolder + " does not exist.";
            logger.error((Object)errMsg);
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, errMsg);
            return;
        }
        if (!folder.canWrite()) {
            String errMsg = "EPG Plugin Installation folder " + installationFolder + " is not writable.";
            logger.error((Object)("EPG Plugin Installation folder " + installationFolder + " is not writable."));
            this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.PLUGIN_FRAMEWORK, errMsg);
            return;
        }
        this.hasFolderError = false;
    }

    public String getInstallationFolder() {
        return this.installationFolder;
    }

    private void uninstallPlugin(EpgFormat format) {
        logger.info((Object)("Uninstall plugin " + format.getId()));
        format.setUpdateDate(new Date());
        format.setActive(false);
        format.setDeleted(true);
        format.setUpdatedBy("System");
        this.epgMetadataManager.updateEpgFormatById(format);
        this.removeJarFileAndCache(format);
    }

    private void removeJarFileAndCache(EpgFormat removedFormat) {
        File jarFile = new File(removedFormat.getJarName());
        PluginFactory.removeCachedPluginJar(jarFile);
    }

    public void setMultipleVersionsSupport(boolean multipleVersionsSupport) {
        this.multipleVersionsSupport = multipleVersionsSupport;
        if (multipleVersionsSupport) {
            logger.info((Object)"Plugin mutiple versions support is enabled");
        } else {
            logger.info((Object)"Plugin mutiple versions support is disabled");
        }
    }
}

