/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entitymanager.EPGMetadataManager;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.utility.io.FileUtils;
import com.ericsson.cms.epgmgmt.utility.misc.PropertiesUtil;
import com.ericsson.epgmgr.plugin.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class JarClassLoader
extends URLClassLoader {
    public static String PLUGIN_TMP_JAR_FILE_PREFIX = "epg_";
    public static int PLUGIN_FOLDER_FILE_SPACE_MAX_LIMIT = 600;
    private static String pluginWorkTmpFolder = "/tmp/epg/";
    private static IEPGMetadataManager epgMetadataManager = (IEPGMetadataManager)ApplicationContextUtil.getBean((String)"epgMetadataManager", EPGMetadataManager.class);
    private static Log logger = LogFactory.getLog(JarClassLoader.class);
    private final Map<String, Class<?>> loadedClass = new HashMap();
    private static Pattern excludeFilesPattern = null;

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static boolean isNotExcludedJar(String fileName) {
        boolean isJar = fileName != null && fileName.toLowerCase().endsWith(".jar");
        return isJar && (excludeFilesPattern == null || !excludeFilesPattern.matcher(fileName).find());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry, String fileName, String extendName) throws IOException {
        File file;
        String localFileName = fileName.substring(0, fileName.lastIndexOf(46));
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int readCount;
            String name = jarEntry.getName();
            int i = name.lastIndexOf(46);
            String extension = i > -1 ? name.substring(i) : "";
            String tempFileName = PLUGIN_TMP_JAR_FILE_PREFIX + localFileName + "_" + name.substring(0, name.length() - extension.length()) + "." + extendName + extension;
            tempFileName = JarClassLoader.getPluginWorkTmpFolder() + File.separator + tempFileName;
            File file2 = new File(tempFileName);
            file2.deleteOnExit();
            input = jarFile.getInputStream(jarEntry);
            output = new FileOutputStream(file2);
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, readCount);
            }
            file = file2;
        }
        catch (Throwable throwable) {
            JarClassLoader.close(input);
            JarClassLoader.close(output);
            throw throwable;
        }
        JarClassLoader.close(input);
        JarClassLoader.close(output);
        return file;
    }

    private void cleanAllEpgFormatObsoleJarFiles(String currentPluginFileName) {
        try {
            JarClassLoader.cleanPluginRelatedJarFiles(FileUtils.getFileNameExcludePathAndSuffix((String)currentPluginFileName));
            List efs = epgMetadataManager.getAllEpgFormatDetails();
            if (CollectionUtils.isEmpty((Collection)efs)) {
                return;
            }
            for (EpgFormat ef : efs) {
                String jarFilePathName = ef.getJarName();
                String jarFileName = FileUtils.getFileNameExcludePathAndSuffix((String)jarFilePathName);
                if (StringUtils.isBlank((String)jarFileName)) continue;
                JarClassLoader.cleanPluginRelatedJarFiles(jarFileName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Clean plugin Obsole jar files failed.", (Throwable)e);
        }
    }

    private static void cleanPluginRelatedJarFiles(String pluginFileName) {
        String folder = JarClassLoader.getPluginWorkTmpFolder();
        long limit = (long)PLUGIN_FOLDER_FILE_SPACE_MAX_LIMIT * 1024L;
        long size = FileUtils.getFolderFilesSize((String)folder);
        int num = 0;
        while (size > limit) {
            FileUtils.cleanTheFolderObsoleFiles((String)folder, (String)(PLUGIN_TMP_JAR_FILE_PREFIX + pluginFileName), (String)".jar");
            size = FileUtils.getFolderFilesSize((String)folder);
            if (num > 100) break;
            ++num;
        }
    }

    public JarClassLoader(URL[] urls, ClassLoader parent) throws IOException {
        super(urls, parent);
        String extendName = String.valueOf(System.currentTimeMillis());
        for (URL url : urls) {
            if (!JarClassLoader.isNotExcludedJar(url.getPath())) continue;
            File file = new File(url.getPath());
            this.addJarResource(file, file.getName(), extendName);
            this.cleanAllEpgFormatObsoleJarFiles(file.getName());
        }
    }

    private void addJarResource(File file, String fileName, String extendName) throws IOException {
        JarFile jarFile = new JarFile(file);
        this.addURL(file.toURI().toURL());
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !JarClassLoader.isNotExcludedJar(jarEntry.getName())) continue;
            this.addJarResource(JarClassLoader.jarEntryAsFile(jarFile, jarEntry, fileName, extendName), fileName, extendName);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        if (name.startsWith("java.")) {
            c = this.getParent().loadClass(name);
        } else {
            c = this.loadedClass.get(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                    this.loadedClass.put(name, c);
                }
                catch (ClassNotFoundException e) {
                    c = this.getParent().loadClass(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = this.getParent().getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            private final Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    public static String getPluginWorkTmpFolder() {
        File file = new File(pluginWorkTmpFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        return pluginWorkTmpFolder;
    }

    @Autowired
    public void setEpgMetadataManager(IEPGMetadataManager epgMetadataManager) {
        JarClassLoader.epgMetadataManager = epgMetadataManager;
    }

    static {
        try {
            PropertiesUtil properties = new PropertiesUtil("applicationContext-epg.properties");
            String str = properties.getProperty("JarClassLoader.excludeJarFiles");
            if (StringUtils.isNotBlank((String)str)) {
                excludeFilesPattern = Pattern.compile(str);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"initilizing error", (Throwable)ex);
        }
    }
}

