/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.PluginPropertyValue;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.TaskTypeEnum;
import com.ericsson.cms.epgmgmt.exception.PluginFrameworkException;
import com.ericsson.cms.epgmgmt.job.Job;
import com.ericsson.cms.epgmgmt.job.ThreadLocalProgressMonitor;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginLogger;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.cms.epgmgmt.service.IConfigurationManager;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.ITaskManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import com.ericsson.cms.epgmgmt.utility.misc.EpgFormatUtil;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.IEPGPluginLogger;
import com.ericsson.epgmgr.plugin.ManagementFeature;
import com.ericsson.epgmgr.plugin.PluginProperty;
import com.ericsson.epgmgr.plugin.StatusMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Exchange;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PluginExecutor {
    private DataSource ds;
    private IEPGManagerPlugin plugin;
    private ITaskManager taskManager;
    private IEPGMetadataManager metadataManager;
    private IConfigurationManager configurationManager;
    private static final Log LOGGER = LogFactory.getLog(PluginExecutor.class);

    public void executePluginForProvider(Exchange exchange, String etvFileLocation) {
        Task task = this.getTask(exchange);
        IEPGManagerProvider ingestPlugin = (IEPGManagerProvider)this.getPlugin(task);
        this.plugin = ingestPlugin;
        this.injectPlugin(exchange);
        List<File> inputFiles = this.extractFilesFromExchange(exchange);
        this.makeParentFile(etvFileLocation, task);
        try {
            List ppList = ingestPlugin.getProperties();
            ppList.addAll(this.createExtenionPluginProperty(task, true));
            EpgFormat format = this.metadataManager.getEpgFormat(task);
            List<PluginPropertyValue> props = this.filterProperty(task.getPluginPropertyValues(), format.getId());
            this.setPluginProperties(props, ppList);
            LOGGER.trace((Object)String.format("Execute plugin for %s with %d plugin properties and %d files.", task.toString(), ppList.size(), inputFiles.size()));
            ingestPlugin.toETVFormat(inputFiles, etvFileLocation, ppList);
        }
        catch (EPGPluginException e) {
            this.logError(task, e);
            throw e;
        }
        catch (Throwable t) {
            String msg = this.logError(task, t);
            throw new PluginFrameworkException(msg, t);
        }
    }

    public void executePluginForPublisher(Exchange exchange, String epgFileLocation) {
        String etvFileLocation = ((File)exchange.getIn().getBody()).getAbsolutePath();
        this.validatePublisherParameters(etvFileLocation);
        Task exportTask = this.getTask(exchange);
        IEPGManagerPublisher exportPlugin = (IEPGManagerPublisher)this.getPlugin(exportTask);
        this.plugin = exportPlugin;
        this.injectPlugin(exchange);
        try {
            this.makeParentFile(etvFileLocation, exportTask);
            List ppList = exportPlugin.getProperties();
            ppList.addAll(this.createExtenionPluginProperty(exportTask, false));
            EpgFormat format = this.metadataManager.getEpgFormat(exportTask);
            List<PluginPropertyValue> props = this.filterProperty(exportTask.getPluginPropertyValues(), format.getId());
            this.setPluginProperties(props, ppList);
            LOGGER.trace((Object)String.format("Execute plugin for %s with %d plugin properties, input file name %s ,output file name %s ", exportTask.toString(), ppList.size(), etvFileLocation, epgFileLocation));
            exportPlugin.fromETVFormat(etvFileLocation, epgFileLocation, ppList);
            this.checkPublisherResult(epgFileLocation, exportTask);
            exchange.getIn().setBody((Object)new File(epgFileLocation));
            exchange.getIn().setHeader("CamelFileName", (Object)epgFileLocation);
            FileUtils.deleteQuietly((File)new File(etvFileLocation));
        }
        catch (EPGPluginException e) {
            this.logError(exportTask, e);
            throw e;
        }
        catch (Throwable t) {
            String msg = this.logError(exportTask, t);
            throw new PluginFrameworkException(msg, t);
        }
    }

    private List<PluginProperty> createExtenionPluginProperty(Task task, boolean isProvider) {
        ArrayList<PluginProperty> pps = new ArrayList<PluginProperty>();
        String partnerTypeKey = "PUBLISHER_ID";
        if (isProvider) {
            partnerTypeKey = "PROVIDER_ID";
        }
        String partnerIdStr = String.valueOf(task.getPartner().getId());
        PluginProperty partnerIdProperty = new PluginProperty(partnerTypeKey, partnerIdStr, partnerIdStr, "", "", "", "");
        pps.add(partnerIdProperty);
        String taskId = String.valueOf(task.getId());
        PluginProperty taskIdProperty = new PluginProperty("TASK_ID", taskId, taskId, "", "", "", "");
        pps.add(taskIdProperty);
        String pluginPath = this.getConfigPluginSeparatedLogPath();
        PluginProperty pluginPathProperty = new PluginProperty("PLUGIN_LOG_PATH", pluginPath, pluginPath, "", "", "", "");
        pps.add(pluginPathProperty);
        return pps;
    }

    private List<PluginPropertyValue> filterProperty(List<PluginPropertyValue> props, String formatId) {
        ArrayList<PluginPropertyValue> result = new ArrayList<PluginPropertyValue>();
        String passingFrameworkFromatId = EpgFormatUtil.getFrameworkFormat((String)formatId);
        for (PluginPropertyValue prop : props) {
            String pluginPropertyId = prop.getPluginProperty().getId();
            String frameworkFromatId = EpgFormatUtil.getFrameworkFormat((String)pluginPropertyId);
            if (!frameworkFromatId.equals(passingFrameworkFromatId)) continue;
            result.add(prop);
        }
        return result;
    }

    private List<File> extractFilesFromExchange(Exchange exchange) {
        List grouped = (List)exchange.getProperty("CamelGroupedExchange", List.class);
        ArrayList<File> inputFiles = new ArrayList<File>(grouped.size());
        for (Exchange eachExchange : grouped) {
            String epgFileLocation = null;
            epgFileLocation = (String)eachExchange.getIn().getHeader("CamelFileNameProduced", String.class);
            if (StringUtils.isEmpty((String)epgFileLocation) || !new File(epgFileLocation).exists()) {
                String msg = " Input file location " + epgFileLocation + " invalid";
                LOGGER.error((Object)msg);
                throw new PluginFrameworkException(msg);
            }
            inputFiles.add(new File(epgFileLocation));
        }
        return inputFiles;
    }

    private IEPGManagerPlugin getPlugin(Task task) {
        EpgFormat format = this.metadataManager.getEpgFormat(task);
        File file = new File(format.getJarName());
        Object epgProvider = task.getType() == TaskTypeEnum.INGEST ? PluginFactory.getProviderPlugin(file) : PluginFactory.getPublisherPlugin(file);
        if (epgProvider == null) {
            throw new EPGPluginException(" PluginFactory returned null for " + format);
        }
        return epgProvider;
    }

    private Task getTask(Exchange exchange) {
        long taskId = RouteBuilderUtils.getTaskId(exchange);
        Task task = this.taskManager.getTask(taskId);
        if (task == null) {
            throw new EPGPluginException(" Can not find task.");
        }
        EpgFormat epgFormat = this.metadataManager.getEpgFormat(task);
        if (epgFormat == null) {
            throw new EPGPluginException(String.format(" Can not find epgFormat for partner(id=%d). ", task.getId()));
        }
        if (!epgFormat.isActive()) {
            throw new EPGPluginException(" The plugin has been deactivated! " + epgFormat.getFormatName());
        }
        return task;
    }

    private void validatePublisherParameters(String etvFileLocation) {
        if (etvFileLocation == null || etvFileLocation.trim().equals("") || !new File(etvFileLocation).exists()) {
            throw new PluginFrameworkException(" Input file location " + etvFileLocation + " invalid");
        }
    }

    private void checkPublisherResult(String epgFileLocation, Task task) {
        if (!new File(epgFileLocation).exists()) {
            throw new PluginFrameworkException("Plugin for Publisher " + task + " did not create output file - " + epgFileLocation);
        }
    }

    private String logError(Task task, Throwable t) {
        String msg = String.format("Failed to execute plugin for [%s:%s] %s", task.getPartner().getName(), task.getName(), t.getMessage());
        LOGGER.error((Object)msg, t);
        return msg;
    }

    private void setPluginProperties(Collection<?> values, List<PluginProperty> ppList) {
        block0: for (Object ppv : values) {
            PluginPropertyValue value = (PluginPropertyValue)ppv;
            for (PluginProperty pp : ppList) {
                if (!pp.getName().equals(value.getPluginProperty().getPropertyName())) continue;
                pp.setConfiguredValue(value.getValue());
                continue block0;
            }
        }
    }

    private void injectPlugin(Exchange exchange) {
        IJob job = (IJob)exchange.getProperty("EXCHANGE_JOB_PROPERTY", Job.class);
        EPGPluginLogger logger = new EPGPluginLogger();
        logger.setSourceId(job.getTask().getPartner().getId());
        logger.setSourceType(job.getTask().getPartner().getPartnerType().toString());
        this.plugin.setLogger((IEPGPluginLogger)logger);
        if (this.plugin instanceof ManagementFeature) {
            ManagementFeature mgmtFeature = (ManagementFeature)this.plugin;
            mgmtFeature.setDataSource(this.ds);
            mgmtFeature.setJobId(job.getId());
            mgmtFeature.setStatusMonitor((StatusMonitor)new PluginExecutionMonitor());
        }
    }

    public void cancel() {
        if (this.plugin instanceof ManagementFeature) {
            ((ManagementFeature)this.plugin).cancel();
        }
    }

    public boolean isCancellable() {
        Map status;
        Boolean isCancellable = true;
        if (this.plugin instanceof ManagementFeature && (isCancellable = (Boolean)(status = ((ManagementFeature)this.plugin).getPluginStatus()).get("isCanCancelPluginKey")) == null) {
            throw new EPGPluginException(" Invalid plugin. \"isCanCancelPluginKey\" should be implemented.");
        }
        return isCancellable;
    }

    private void makeParentFile(String etvFileLocation, Task task) {
        File parentDir = new File(etvFileLocation).getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new PluginFrameworkException(String.format("Failed to create %s for %s", parentDir, task.toString()));
        }
    }

    private String getConfigPluginSeparatedLogPath() {
        String logFolder = this.configurationManager.getConfigStringValue("pluginSeparatedLogPath");
        if (StringUtils.isBlank((String)logFolder)) {
            logFolder = "/opt/tandbergtv/cms/log/epg/roviplugin/";
        }
        return logFolder;
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    @Autowired
    public void setTaskManager(ITaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Autowired
    public void setMetadataManager(IEPGMetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Autowired
    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    private final class PluginExecutionMonitor
    implements StatusMonitor {
        private PluginExecutionMonitor() {
        }

        public void setProgress(int percentage) {
            ThreadLocalProgressMonitor.reportProgress(percentage);
        }

        public void addWarningMessage(String warningMessage) {
            MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.WARNING, "", warningMessage, PluginLogComponent.PLUGIN));
        }
    }
}

