/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.plugin;

import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entitymanager.EPGMetadataManager;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginLogger;
import com.ericsson.cms.epgmgmt.plugin.JarClassLoader;
import com.ericsson.cms.epgmgmt.service.IEPGMetadataManager;
import com.ericsson.epgmgr.plugin.EPGPluginException;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerProvider;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import com.ericsson.epgmgr.plugin.IEPGPluginLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginFactory {
    private static Log log = LogFactory.getLog(PluginFactory.class);
    private static Map<String, PluginJarInfo> cachedPluginJars = new ConcurrentHashMap<String, PluginJarInfo>();
    private static IEPGMetadataManager metadataManager = (IEPGMetadataManager)ApplicationContextUtil.getBean((String)"epgMetadataManager", EPGMetadataManager.class);

    private static void initializePlugin(IEPGManagerPlugin plugin) {
        Locale locale = Locale.getDefault();
        plugin.setLogger((IEPGPluginLogger)new EPGPluginLogger());
        plugin.setLocale(locale);
    }

    private static <T extends IEPGManagerPlugin> T getPlugin(File file, Class<T> typeOfPlugin) {
        URLClassLoader urlCl;
        try {
            urlCl = PluginFactory.getPluginClassLoader(file);
        }
        catch (MalformedURLException e) {
            throw new EPGPluginException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new EPGPluginException(e.getMessage(), (Throwable)e);
        }
        try {
            ServiceLoader<T> pluginServiceLoader = ServiceLoader.load(typeOfPlugin, urlCl);
            Iterator<T> pluginIterator = pluginServiceLoader.iterator();
            if (pluginIterator.hasNext()) {
                log.debug((Object)("Load Plugin Jar File to IEPGManagerPublisher or IEPGManagerProvider Class by ServiceLoader:" + pluginIterator));
                IEPGManagerPlugin plugin = (IEPGManagerPlugin)pluginIterator.next();
                PluginFactory.initializePlugin(plugin);
                return (T)plugin;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Load Plugin Jar File by ServiceLoader Failed. ", e);
        }
        return null;
    }

    private static URLClassLoader getPluginClassLoader(File file) throws IOException {
        URLClassLoader urlCl = null;
        PluginJarInfo cachedPluginJarInfo = cachedPluginJars.get(file.getName());
        PluginJarInfo lastestPluginJarInfo = PluginFactory.getPluginJarClassLoaderInfo(file);
        byte[] digest = null;
        if (PluginFactory.findCachedPluginJarInfo(cachedPluginJarInfo)) {
            boolean sameFileSizeAndTimestampChanged;
            boolean sameFileSizeAndTimestamp = cachedPluginJarInfo.getFileSize() == lastestPluginJarInfo.getFileSize() && cachedPluginJarInfo.getTimestamp() == lastestPluginJarInfo.getTimestamp();
            boolean bl = sameFileSizeAndTimestampChanged = cachedPluginJarInfo.getFileSize() == lastestPluginJarInfo.getFileSize() && cachedPluginJarInfo.getTimestamp() != lastestPluginJarInfo.getTimestamp();
            if (sameFileSizeAndTimestamp) {
                urlCl = cachedPluginJarInfo.getClassLoader();
            }
            if (sameFileSizeAndTimestampChanged) {
                boolean sameFileInMD5;
                digest = DigestUtils.md5((byte[])FileUtils.readFileToByteArray((File)file));
                boolean bl2 = sameFileInMD5 = digest.length > 0 && Arrays.equals(digest, cachedPluginJarInfo.getMd5());
                if (sameFileInMD5) {
                    cachedPluginJarInfo.setTimestamp(lastestPluginJarInfo.getTimestamp());
                    cachedPluginJarInfo.setFileSize(lastestPluginJarInfo.getFileSize());
                    urlCl = cachedPluginJarInfo.getClassLoader();
                }
            }
        }
        if (urlCl == null) {
            URL url = file.toURI().toURL();
            url.openConnection().setUseCaches(false);
            urlCl = new JarClassLoader(new URL[]{url}, PluginFactory.class.getClassLoader());
            lastestPluginJarInfo.setClassLoader(urlCl);
            lastestPluginJarInfo.setMd5(digest == null ? DigestUtils.md5((byte[])FileUtils.readFileToByteArray((File)file)) : digest);
            cachedPluginJars.put(file.getName(), lastestPluginJarInfo);
        }
        return urlCl;
    }

    private static boolean findCachedPluginJarInfo(PluginJarInfo cachedJarCLInfo) {
        return cachedJarCLInfo != null && cachedJarCLInfo.getClassLoader().getParent() == PluginFactory.class.getClassLoader();
    }

    public static IEPGManagerProvider getProviderPlugin(File file) {
        return PluginFactory.getPlugin(file, IEPGManagerProvider.class);
    }

    public static IEPGManagerPublisher getPublisherPlugin(File file) {
        return PluginFactory.getPlugin(file, IEPGManagerPublisher.class);
    }

    public static IEPGManagerProvider getProviderPlugin(Task task) {
        EpgFormat format = metadataManager.getEpgFormat(task);
        return PluginFactory.getProviderPlugin(new File(format.getJarName()));
    }

    public static IEPGManagerPublisher getPublisherPlugin(Task task) {
        EpgFormat format = metadataManager.getEpgFormat(task);
        return PluginFactory.getPublisherPlugin(new File(format.getJarName()));
    }

    public static PluginJarInfo getPluginJarClassLoaderInfo(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        return new PluginJarInfo(file.getAbsolutePath(), file.lastModified(), file.length());
    }

    public static PluginJarInfo removeCachedPluginJar(File file) {
        return cachedPluginJars.remove(file.getName());
    }

    public static void setMetadataManager(IEPGMetadataManager metadataManager) {
        PluginFactory.metadataManager = metadataManager;
    }

    static class PluginJarInfo {
        private String fileName;
        private long timestamp;
        private long fileSize;
        private byte[] md5;
        private URLClassLoader classLoader;

        PluginJarInfo(String fileName, long timestamp, long fileSize) {
            this.fileName = fileName;
            this.timestamp = timestamp;
            this.fileSize = fileSize;
        }

        public byte[] getMd5() {
            return this.md5;
        }

        public void setMd5(byte[] md5Array) {
            this.md5 = md5Array == null ? new byte[]{} : Arrays.copyOf(md5Array, md5Array.length);
        }

        public URLClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(URLClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public String toString() {
            return String.format("PluginJarClassLoaderInfo, fileName: %s, timestamp: %d, fileSize: %d", this.fileName, this.timestamp, this.fileSize);
        }
    }
}

