/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.runtime;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class MemoryChecker {
    public static final String SETTING_MINIMUM_FREE_MEMORY = "minimum.free.memory";
    private static final double BYTES_OF_GIGABYTE = 1.073741824E9;
    private IConfigurationService configurationService;

    public boolean enoughMemory() {
        try {
            long neededMemory = Long.parseLong((String)this.configurationService.getProperties("com.ericsson.cms.epgmgmt.configuration").get(SETTING_MINIMUM_FREE_MEMORY));
            return this.getAvailableMemory() >= (double)neededMemory;
        }
        catch (Exception e) {
            return true;
        }
    }

    public double getAvailableMemory() {
        return (double)(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1.073741824E9;
    }

    @Autowired
    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

