/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.authorization.EPGLicenseUtils;
import com.ericsson.cms.epgmgmt.camel.FtpComponentExt;
import com.ericsson.cms.epgmgmt.camel.FtpConsumerExt;
import com.ericsson.cms.epgmgmt.camel.FtpEndpointExt;
import com.ericsson.cms.epgmgmt.camel.SFtpComponentExt;
import com.ericsson.cms.epgmgmt.camel.route.ExportRoute;
import com.ericsson.cms.epgmgmt.camel.route.FtpIngestRoute;
import com.ericsson.cms.epgmgmt.camel.routebuilder.RouteFactory;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.service.ICamelManager;
import com.ericsson.cms.epgmgmt.service.IJob;
import com.ericsson.cms.epgmgmt.service.PublishFilterSource;
import com.ericsson.cms.epgmgmt.util.ConfigProperties;
import com.ericsson.cms.epgmgmt.util.ExportTaskUtil;
import com.ericsson.cms.epgmgmt.util.RouteBuilderUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.ejb.EjbComponent;
import org.apache.camel.component.file.remote.SftpConsumer;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CamelManager
implements ICamelManager {
    private CamelContext camelContext;
    private static Logger logger = Logger.getLogger(CamelManager.class);
    public static final String FTP_TO_DATABASE_DIRECT_ENDPOINT_URI = "direct:ftpToDatabase";
    public static final String FTP_TO_DATABASE_URI = "ftp://{{ftp.username}}@{{dbserver}}:{{ftp.port}}/public/epgmanager?password={{ftp.password}}&ftpClient.remoteVerificationEnabled=false&fileName=Guidedata.xml&separator=UNIX&passiveMode=true&disconnect=true&stepwise=false";
    public static final String VALIDATION_URI = "validator:ETV_EPG.xsd";
    private FtpIngestRoute ftpIngestRoute;
    private ExportRoute exportRoute;
    private PropertiesComponent propertiesComponent;
    private RouteFactory routeFactory;

    private void addFtpToDatabaseRoute() throws Exception {
        this.camelContext.addRoutes((RoutesBuilder)this.ftpIngestRoute);
        this.camelContext.addRoutes((RoutesBuilder)this.exportRoute);
    }

    private void intializeEjbContext() {
        try {
            logger.debug((Object)" Intializing Ejb context for Camel");
            EjbComponent ejb = (EjbComponent)this.camelContext.getComponent("ejb", EjbComponent.class);
            InitialContext context = new InitialContext();
            ejb.setContext((Context)context);
        }
        catch (Exception e) {
            logger.error((Object)" Failed to initialize Ejb Context for Camel ", (Throwable)e);
        }
    }

    public boolean isCamelRunning() {
        return this.getCamelContextStatus().equals((Object)ServiceStatus.Started) || this.getCamelContextStatus().equals((Object)ServiceStatus.Starting);
    }

    public void createTaskRoute(IJob job) throws Exception {
        this.camelContext.addRoutes((RoutesBuilder)this.routeFactory.createTaskJobRoute(job));
    }

    public void removeTaskRoute(Task task) throws Exception {
        switch (task.getType()) {
            case INGEST: {
                this.removeIngestRoute(task);
                break;
            }
            case EXPORT: {
                this.removeExportRoute(task);
            }
        }
    }

    private void cleanProviderWorkFolder(Task task) throws IOException {
        String folder = ConfigProperties.getWorkFolderForIngestTask(task);
        File workFolder = new File(folder);
        if (workFolder.exists()) {
            FileUtils.cleanDirectory((File)workFolder);
        }
    }

    private void removeIngestRoute(Task task) throws Exception {
        String routeId = RouteBuilderUtils.getRouteId(task);
        Route route = this.camelContext.getRoute(routeId);
        if (route == null) {
            logger.info((Object)("try to remove route, but Route for task " + task.getName() + " not found."));
            return;
        }
        this.forceCloseRunningFtpConsumer(route.getConsumer());
        this.stopRoute(routeId, 2, false);
        this.cleanProviderWorkFolder(task);
    }

    private void removeExportRoute(Task task) throws Exception {
        String routeId = RouteBuilderUtils.getRouteId(task);
        if (this.camelContext.getRoute(routeId) == null) {
            logger.info((Object)("try to remove route, but Route for task " + task.getName() + " not found."));
            return;
        }
        this.stopRoute(routeId, 2, false);
        this.forceCloseRunningFtpProducer(task);
    }

    private ServiceStatus getCamelContextStatus() {
        return this.camelContext == null ? ServiceStatus.Stopped : this.camelContext.getStatus();
    }

    private boolean stopRoute(String routeId, int timeout, boolean gracefulclose) throws Exception {
        boolean success = false;
        boolean bl = success = this.camelContext.stopRoute(routeId, (long)timeout, TimeUnit.SECONDS, gracefulclose) && this.camelContext.removeRoute(routeId);
        if (!success) {
            logger.info((Object)("Unable to remove route for " + routeId));
        }
        return success;
    }

    private void forceCloseRunningFtpConsumer(Consumer service) {
        if (service instanceof FtpConsumerExt) {
            FtpConsumerExt ftpConsumer = (FtpConsumerExt)service;
            ftpConsumer.forceDisconnect();
        } else if (service instanceof SftpConsumer) {
            SftpConsumer sftpConsumer = (SftpConsumer)service;
            try {
                sftpConsumer.stop();
            }
            catch (Exception e) {
                logger.error((Object)"Ingest Process Stoping SFTP failed: ", (Throwable)e);
            }
        }
    }

    private void forceCloseRunningFtpProducer(Task p) {
        Endpoint e = this.camelContext.getEndpoint(ExportTaskUtil.getEndpointUri(p.getEndpoint()));
        if (e instanceof FtpEndpointExt) {
            FtpEndpointExt ep = (FtpEndpointExt)e;
            String routeName = RouteBuilderUtils.getRouteId(p);
            ep.stopFtpOperations(routeName);
        } else if (e instanceof SftpEndpoint) {
            try {
                SftpEndpoint ep = (SftpEndpoint)e;
                ep.stop();
            }
            catch (Exception e1) {
                logger.error((Object)"Export Process Stoping SFTP failed: ", (Throwable)e1);
            }
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        logger.info((Object)" Stopping Camel for EPG Manager...");
        if (this.camelContext == null) {
            logger.error((Object)"Camelcontext is null");
            return;
        }
        if (this.camelContext.getStatus().equals((Object)ServiceStatus.Stopped)) {
            logger.error((Object)"Camelcontext is not running");
            return;
        }
        List routes = this.camelContext.getRoutes();
        for (Route route : routes) {
            this.camelContext.stopRoute(route.getId(), 5L, TimeUnit.SECONDS, false);
        }
        this.camelContext.stop();
    }

    @PostConstruct
    public void start() throws Exception {
        if (!EPGLicenseUtils.isLicensed()) {
            logger.info((Object)" EPG Manager is not licensed.");
            return;
        }
        logger.info((Object)" Starting Camel for EPG Manager...");
        ConfigProperties.init();
        if (this.isCamelRunning()) {
            logger.error((Object)" Attempt to restart Camel when its already running!");
            return;
        }
        logger.debug((Object)" Creating default camelContext ");
        this.camelContext.getShutdownStrategy().setShutdownNowOnTimeout(true);
        this.camelContext.getShutdownStrategy().setTimeout(5L);
        this.camelContext.getShutdownStrategy().setTimeUnit(TimeUnit.SECONDS);
        this.camelContext.removeComponent("ftp");
        this.camelContext.addComponent("ftp", (Component)new FtpComponentExt());
        this.camelContext.removeComponent("sftp");
        this.camelContext.addComponent("sftp", (Component)new SFtpComponentExt());
        this.camelContext.removeComponent("properties");
        this.camelContext.addComponent("properties", (Component)this.propertiesComponent);
        FileUtils.forceMkdir((File)new File(ConfigProperties.getFtpTempFolderFromDatabase()));
        this.intializeEjbContext();
        this.addFtpToDatabaseRoute();
        this.camelContext.disableJMX();
        this.camelContext.start();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Autowired
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Autowired
    public void setExportRoute(ExportRoute exportRoute) {
        this.exportRoute = exportRoute;
    }

    @Autowired
    public void setFtpIngestRoute(FtpIngestRoute ftpIngestRoute) {
        this.ftpIngestRoute = ftpIngestRoute;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Autowired
    public void setPublishFilterParameter(PublishFilterSource publishFilterParameter) {
    }

    @Autowired
    public void setRouteFactory(RouteFactory routeFactory) {
        this.routeFactory = routeFactory;
    }
}

