/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.job.ThreadLocalCancelChecker;
import com.ericsson.cms.epgmgmt.job.ThreadLocalProgressMonitor;
import com.ericsson.cms.epgmgmt.lifecycle.ApplicationContextUtil;
import com.ericsson.cms.epgmgmt.service.ActivityLogger;
import com.ericsson.cms.epgmgmt.service.PublishFilterSource;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.util.PartnerIdThreadLocal;
import com.ericsson.cms.epgmgmt.util.TableMerger;
import com.ericsson.cms.epgmgmt.utility.db.ScriptRunner;
import com.ericsson.cms.epgmgmt.utility.db.replicator.DBReplicationConfig;
import com.ericsson.cms.epgmgmt.utility.db.replicator.DBReplicator;
import com.ericsson.cms.epgmgmt.utility.db.replicator.IReader;
import com.ericsson.cms.epgmgmt.utility.db.replicator.RecordListReader;
import com.ericsson.cms.epgmgmt.utility.db.replicator.Table;
import com.ericsson.cms.epgmgmt.utility.misc.StringLoader;
import com.ericsson.cms.epgmgmt.utility.time.StackTimer;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public class EpgDbStore {
    private static Logger logger = Logger.getLogger(EpgDbStore.class);
    private final StringLoader sqlCmdLoader = (StringLoader)ApplicationContextUtil.getBean((String)"stringLoader");
    private final String[] stgTables = ApplicationContextUtil.getStrArray((String)"stagingTables");
    private final String[] prodTables = ApplicationContextUtil.getStrArray((String)"productionTables");
    private final String[] productionToExpTables = ApplicationContextUtil.getStrArray((String)"productionToExpTables");
    private static final int H2O_WRITE_THREAD_COUNT = 15;
    private static final int H2O_RECORDS_PER_THREAD = 800;
    private static final int O2H_RECORD_PER_THREAD = 800;
    private final DataSource h2DataSource;
    private final DataSource oracleDataSource;
    private final JdbcTemplate h2JdbcTemplate;
    private final JdbcTemplate masterDBJdbcTemplate;
    private ScriptRunner scriptRunner;
    private static MutableBoolean h2StgTablesCreated = new MutableBoolean(false);
    private static MutableBoolean h2ProdTablesCreated = new MutableBoolean(false);
    private static MutableBoolean h2ExpTablesCreated = new MutableBoolean(false);
    private static boolean stgLoaded = false;
    private final DBReplicator replicator;

    public EpgDbStore(DataSource oracleDataSource, DataSource h2DataSource, ScriptRunner scriptRunner) {
        this.oracleDataSource = oracleDataSource;
        this.h2DataSource = h2DataSource;
        this.scriptRunner = scriptRunner;
        this.h2JdbcTemplate = new JdbcTemplate(h2DataSource);
        this.masterDBJdbcTemplate = new JdbcTemplate(oracleDataSource);
        this.replicator = new DBReplicator(15);
    }

    public void cleanupAllH2Objects() throws SQLException {
        this.h2JdbcTemplate.execute("drop all objects;");
        h2StgTablesCreated.setValue(false);
        h2ProdTablesCreated.setValue(false);
        h2ExpTablesCreated.setValue(false);
        stgLoaded = false;
    }

    public void copyOracleStgToH2Stg(boolean forceLoad, long providerId) throws IOException, SQLException {
        ThreadLocalCancelChecker.checkCancel();
        if (forceLoad || !stgLoaded) {
            this.dropH2Stg();
            this.createH2StagingTables();
            stgLoaded = true;
            try {
                this.copyOracleStgToH2StgImpl(providerId);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                this.dropH2Stg();
                stgLoaded = false;
            }
        } else {
            logger.info((Object)"Master staging data has been loaded. No need to load it again.");
        }
    }

    private void copyOracleStgToH2StgImpl(long providerId) throws InterruptedException, ExecutionException, SQLException {
        Table[] mastToH2StgTables;
        HashMap<String, Long> model = new HashMap<String, Long>();
        model.put("provider_id", providerId);
        for (Table prodTable : mastToH2StgTables = this.getTables(this.stgTables)) {
            prodTable.SetModel(model);
        }
        this.replicator.replicate(this.oracleDataSource, this.h2DataSource, mastToH2StgTables, DBReplicationConfig.ReplicateDirection.STG_TO_STG, 800);
    }

    public void copyOracleProdToH2Prod(Map<String, Object> model) throws IOException, ExecutionException, SQLException {
        Table[] productinTables;
        this.dropAndRecreateH2Prod();
        for (Table prodTable : productinTables = this.getTables(this.prodTables)) {
            prodTable.SetModel(model);
        }
        this.replicator.replicate(this.oracleDataSource, this.h2DataSource, productinTables, DBReplicationConfig.ReplicateDirection.PROD_TO_PROD, 800);
    }

    public void dropAndRecreateH2Prod() throws IOException {
        ThreadLocalCancelChecker.checkCancel();
        this.dropH2Prod();
        this.createH2ProductionTables();
    }

    public void copyH2ProdToOracleProd(Map<String, Object> model) throws ExecutionException, SQLException {
        Table[] productinTables;
        ThreadLocalCancelChecker.checkCancel();
        this.logInfo("Copy memory production tables to master production tables.", PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
        for (Table prodTable : productinTables = this.getTables(this.prodTables)) {
            prodTable.SetModel(model);
        }
        this.replicator.replicate(this.h2DataSource, this.oracleDataSource, productinTables, DBReplicationConfig.ReplicateDirection.PROD_TO_PROD, 800);
    }

    public void copyH2Stg2OracleProd() throws InterruptedException, ExecutionException, SQLException {
        this.replicator.replicate(this.h2DataSource, this.oracleDataSource, this.getTables(this.stgTables), this.getTables(this.prodTables), DBReplicationConfig.ReplicateDirection.STG_TO_PROD, 800);
    }

    private void copyRecordsToProdTable(Collection<Object[]> collection, Table table) throws ExecutionException, SQLException {
        this.replicator.replicate((IReader)new RecordListReader(collection), this.h2DataSource, table, DBReplicationConfig.ReplicateDirection.PROD_TO_PROD, 800);
    }

    public void copyRecordsToH2StgTable(Collection<Object[]> collection, Table table) throws ExecutionException, SQLException {
        this.replicator.replicate((IReader)new RecordListReader(collection), this.h2DataSource, table, DBReplicationConfig.ReplicateDirection.STG_TO_STG, 800);
    }

    public void logInfo(String logStr, PluginLogComponent stage, long sourceId, PartnerTypeEnum sourceType) {
        logger.info((Object)logStr);
        ActivityLogger.getInstance().log(PluginLogSeverity.INFORMATION, stage, logStr, sourceId, sourceType.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.INFO, "", logStr, stage));
    }

    public void copyMasterProdToH2Exp(Task task, PublishFilterSource filterSource) throws IOException, SQLException, InterruptedException, ExecutionException {
        Table[] productinTables;
        StackTimer timer = new StackTimer();
        timer.mark();
        this.logInfo("Copy Master production tables to H2 export tables.", PluginLogComponent.EXPORT_TO_STG, task.getPartner().getId(), PartnerTypeEnum.Receiver);
        this.createH2ExpTables();
        this.truncateH2Exp();
        String publisherName = task.getName();
        long publisherId = task.getId();
        String programStationRelatedSchedule = filterSource.getExcludeProgram();
        String providerIds = filterSource.getProviderId();
        String channelIds = filterSource.getStationId();
        String headendIds = filterSource.getHeadendId();
        String lowerDate = filterSource.getStartTime();
        String upperDate = filterSource.getEndTime();
        boolean filterByDate = StringUtils.isNotEmpty((String)lowerDate);
        boolean filterByChannels = StringUtils.isNotEmpty((String)channelIds);
        boolean filterByHeadends = StringUtils.isNotEmpty((String)headendIds);
        logger.info((Object)("ETV export filter PrublisherId :" + publisherId));
        logger.info((Object)("ETV export filter ProviderId :" + providerIds));
        logger.info((Object)("ETV export filter ChanelId :" + channelIds));
        logger.info((Object)("ETV export filter HeadendId :" + headendIds));
        logger.info((Object)("ETV export filter StartTime :" + lowerDate));
        logger.info((Object)("ETV export filter EndTime :" + upperDate));
        logger.info((Object)("ETV export filter filterByDate :" + filterByDate));
        logger.info((Object)("ETV export filter filterByChannels :" + filterByChannels));
        logger.info((Object)("ETV export filter filterByHeadends :" + filterByHeadends));
        logger.info((Object)("ETV export filter filterByProgramStationExclude :" + programStationRelatedSchedule));
        String dateFilter = String.format(" s.START_TIME >= '%s' and s.START_TIME <= '%s'", lowerDate, upperDate);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("filterByChannels", filterByChannels);
        model.put("channelFilter", channelIds);
        model.put("filterByHeadends", filterByHeadends);
        model.put("headendFilter", headendIds);
        model.put("filterByDate", filterByDate);
        model.put("dateFilter", dateFilter);
        model.put("provider_id", providerIds);
        model.put("programStationRelatedSchedule", Boolean.parseBoolean(programStationRelatedSchedule));
        if (StringUtils.isBlank((String)providerIds)) {
            throw new IllegalArgumentException("Provider filter (mandatory) is not set for the publisher " + publisherName);
        }
        for (Table prodTable : productinTables = this.getTables(this.productionToExpTables)) {
            prodTable.SetModel(model);
        }
        this.replicator.replicate(this.oracleDataSource, this.h2DataSource, productinTables, DBReplicationConfig.ReplicateDirection.PROD_TO_PROD, 800);
        this.logInfo("Copy Master production tables to H2 export tables done, took " + timer.timeIt() + " seconds.", PluginLogComponent.EXPORT_TO_STG, task.getPartner().getId(), PartnerTypeEnum.Receiver);
    }

    public void deleteOldScheduleData() {
        ThreadLocalCancelChecker.checkCancel();
        this.logInfo("Remove old schedule data on memory before merge.", PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
        Timestamp vminstgschdate = (Timestamp)this.h2JdbcTemplate.queryForObject(this.sqlCmdLoader.getString("queryMinStartTime"), Timestamp.class);
        if (vminstgschdate == null) {
            logger.info((Object)"no shedule data in this ingestion");
            return;
        }
        Timestamp vmaxstgschdate = (Timestamp)this.h2JdbcTemplate.queryForObject(this.sqlCmdLoader.getString("queryMaxStartTime"), Timestamp.class);
        logger.info((Object)String.format("deleteOldScheduleData, vminstgschdate=%s, vmaxstgschdate=%s", vminstgschdate.toString(), vmaxstgschdate.toString()));
        this.h2JdbcTemplate.execute(this.sqlCmdLoader.getString("createTempStationSchRange"));
        logger.info((Object)"temp_station_sch_range is created");
        this.h2JdbcTemplate.execute(this.sqlCmdLoader.getString("insertTempStationSchRange"));
        logger.info((Object)"update temp_station_sch_range");
        this.h2JdbcTemplate.update(this.sqlCmdLoader.getString("deleteSchedule"), new Object[]{vminstgschdate, vmaxstgschdate, vminstgschdate, vmaxstgschdate});
        logger.info((Object)"old schedule data is removed.");
    }

    public void purgeMasterProd(int daysBehindNowToKeep, long providerId) {
        String[] deleteTables;
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("currProviderId", String.valueOf(providerId));
        ThreadLocalCancelChecker.checkCancel();
        this.logInfo("Purge master production tables.", PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
        Calendar cutTimeCalendar = Calendar.getInstance();
        cutTimeCalendar.add(6, -daysBehindNowToKeep);
        Timestamp cutTime = new Timestamp(cutTimeCalendar.getTimeInMillis());
        String sqlCmd = this.sqlCmdLoader.getString("queryOldSchedule", model);
        int scheduleCntBeforeCutTime = (Integer)this.masterDBJdbcTemplate.queryForObject(sqlCmd, new Object[]{cutTime}, Integer.class);
        logger.info((Object)String.format("purge old date before %s", new SimpleDateFormat("yyyy-MM-dd").format(cutTime)));
        logger.info((Object)("purgeMasterProd, scheduleCntBeforeCutTime=" + scheduleCntBeforeCutTime));
        if (scheduleCntBeforeCutTime <= 0) {
            return;
        }
        String queryProvaramSqlFormat = "delete from %s se where se.provider_id=%s and exists (     select program_id from schedule s     where START_TIME < '%s'     and program_id not in (select distinct program_id from schedule where START_TIME > '%s' and provider_id = %s)     and se.program_id = s.program_id and s.provider_id = se.provider_id )";
        for (String table : deleteTables = new String[]{"SCHEDULE_EVENT_ID", "SCHEDULE_SERIES_ATTRIB", "SCHEDULE_GENERIC"}) {
            String sql = String.format(queryProvaramSqlFormat, table, providerId, cutTime, cutTime, providerId);
            int num = this.masterDBJdbcTemplate.update(sql);
            logger.info((Object)String.format("Deleted Obsolete %s rows from table %s, Provider[%s]", num, table, providerId));
        }
        this.masterDBJdbcTemplate.update(this.sqlCmdLoader.getString("deleteOldSchedule", model), new Object[]{cutTime});
        String infoStr = String.format("Completed purge of old production data.", new Object[0]);
        logger.info((Object)infoStr);
    }

    public void mergeH2StgToH2Prod(boolean overwriteWithEmpty, Map<String, Object> model) throws IOException, ExecutionException, SQLException {
        ThreadLocalCancelChecker.checkCancel();
        this.logInfo("Merge memory staging tables to memory production tables.", PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
        this.decoupleH2ProdConstraints();
        Table[] tables = this.getTables(this.prodTables);
        float step = 25.0f / (float)tables.length;
        for (int i = 0; i < tables.length; ++i) {
            Table prodTable = tables[i];
            prodTable.SetModel(model);
            ThreadLocalCancelChecker.checkCancel();
            logger.info((Object)("merging " + prodTable.getTableName()));
            TableMerger dbMerger = new TableMerger(this.h2DataSource, prodTable, overwriteWithEmpty);
            dbMerger.merge();
            this.h2JdbcTemplate.execute("truncate table " + prodTable.getTableName());
            ThreadLocalCancelChecker.checkCancel();
            logger.info((Object)String.format("merge,copy record to %s", prodTable.getTableName()));
            this.copyRecordsToProdTable(dbMerger.getMergeRecord(), prodTable);
            logger.info((Object)("merging " + prodTable.getTableName() + " done"));
            ThreadLocalProgressMonitor.reportProgress((int)(50.0f + step * (float)(i + 1)));
        }
    }

    public void generateMergeReport(long providerId) {
        ThreadLocalCancelChecker.checkCancel();
        int headendCount = this.h2JdbcTemplate.queryForInt("select count(*) from stg_headend");
        int lineupCount = this.h2JdbcTemplate.queryForInt("select count(*) from stg_lineup");
        int stationCount = this.h2JdbcTemplate.queryForInt("select count(*) from stg_station");
        int programCount = this.h2JdbcTemplate.queryForInt("select count(*) from stg_program");
        int scheduleCount = this.h2JdbcTemplate.queryForInt("select count(*) from stg_schedule");
        Timestamp scheduleBot = (Timestamp)this.h2JdbcTemplate.queryForObject("select min(START_TIME) from stg_schedule", Timestamp.class);
        Timestamp scheduleTop = (Timestamp)this.h2JdbcTemplate.queryForObject("select max(START_TIME) from stg_schedule", Timestamp.class);
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd");
        String scheduleInfo = scheduleCount == 0 ? "0" : String.format("%d, %s to %s", scheduleCount, dataFormat.format(scheduleBot), dataFormat.format(scheduleTop));
        String logStr = String.format("EPG merge report: Headends(%d),Lineups(%d),Stations(%d),Programs(%d),Schedules(%s)", headendCount, lineupCount, stationCount, programCount, scheduleInfo);
        this.logInfo(logStr, PluginLogComponent.MERGE, providerId, PartnerTypeEnum.Provider);
    }

    private Table[] getTables(String[] tableNames) {
        int tableNum = tableNames.length;
        Table[] tables = new Table[tableNum];
        for (int i = 0; i < tableNum; ++i) {
            tables[i] = this.getTable(tableNames[i]);
        }
        return tables;
    }

    public Table getTable(String tableName) {
        return (Table)ApplicationContextUtil.getBean((String)tableName, Table.class);
    }

    private void createTableHelper(MutableBoolean condition, String h2Script) throws IOException {
        if (condition.booleanValue()) {
            logger.info((Object)(h2Script + " has run, no need to run again."));
        } else {
            this.runH2Script(h2Script);
            condition.setValue(true);
        }
    }

    private void createH2StagingTables() throws IOException {
        this.createTableHelper(h2StgTablesCreated, "createH2StagingTables.sql");
    }

    private void createH2ProductionTables() throws IOException {
        this.createTableHelper(h2ProdTablesCreated, "createH2ProductionTables.sql");
    }

    private void createH2ExpTables() throws IOException {
        this.createTableHelper(h2ExpTablesCreated, "createH2ExportTables.sql");
    }

    private void decoupleOracleProdTables() throws IOException {
        this.runOracleScript("decoupleProdTables.sql");
    }

    private void coupleOracleProdTables() throws IOException {
        this.runOracleScript("coupleProdTables.sql");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateOracleProduction(long providerId) throws IOException, SQLException {
        ThreadLocalCancelChecker.checkCancel();
        this.logInfo("Deleting master production tables by ProviderId: " + providerId, PluginLogComponent.MERGE, PartnerIdThreadLocal.getPartnerId(), PartnerTypeEnum.Provider);
        try {
            this.decoupleOracleProdTables();
            for (String prodTable : this.prodTables) {
                String sqlCmd = String.format("delete from %s where PROVIDER_ID = %d", prodTable, providerId);
                logger.debug((Object)("truncate table on Master DB:" + prodTable));
                this.masterDBJdbcTemplate.execute(sqlCmd);
            }
        }
        finally {
            this.coupleOracleProdTables();
        }
    }

    private void truncateH2Exp() throws IOException, SQLException {
        this.runH2Script("truncateH2ExpTables.sql");
    }

    private void dropH2Stg() throws IOException {
        this.runH2Script("dropH2StgTables.sql");
        h2StgTablesCreated.setValue(false);
    }

    public void dropH2Prod() throws IOException {
        this.runH2Script("dropH2ProdTables.sql");
        h2ProdTablesCreated.setValue(false);
    }

    private void decoupleH2ProdConstraints() throws IOException {
        this.runH2Script("decoupleH2ProdConstraints.sql");
    }

    private void runOracleScript(String script) throws IOException {
        this.runScript("/sqlscripts/oracle/" + script, false, false);
    }

    private void runH2Script(String script) throws IOException {
        boolean runInH2 = true;
        this.runScript("/sqlscripts/h2/" + script, true, false);
    }

    private void runScript(String script, boolean isH2, boolean isSetDelimiter) throws IOException {
        logger.debug((Object)String.format("run script %s on %s", script, isH2 ? "memory" : "master"));
        DataSource ds = isH2 ? this.h2DataSource : this.oracleDataSource;
        InputStream is = EpgDbStore.class.getResourceAsStream(script);
        this.scriptRunner.runScript(ds, is, isSetDelimiter);
    }

    public void shutdownReplicator() {
        this.replicator.shutdown();
    }

    public void setScriptRunner(ScriptRunner scriptRunner) {
        this.scriptRunner = scriptRunner;
    }

    public void dump(String table, String postFix) {
        String sql = String.format("CALL CSVWRITE('/tmp/%s_%s.csv', 'select * from %s')", table, postFix, table);
        this.h2JdbcTemplate.execute(sql);
    }
}

