/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.service.IMailService;
import com.ericsson.cms.epgmgmt.util.ConfigurationServiceUtil;
import com.ericsson.cms.epgmgmt.util.MailUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MailService
implements IMailService {
    private static Logger logger = Logger.getLogger(MailService.class);
    public static final String STOP_TASK_SUBJECT = "Force stop";
    private static final String SEPARATE_SYMBOL = "\n\r";
    private static final String SEPARATE = "  ";
    private String fromAddress;
    private ConfigurationServiceUtil configurationServiceUtil;
    private JavaMailSenderImpl mailSender;

    private void sendMimeMessage(String[] to, List<String> ccList, EmailAlertLevelEnum level, List<String> errorMsgs, PluginLogComponent component) throws MessagingException {
        MimeMessage mailMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "utf-8");
        messageHelper.setFrom(this.getFromAddress());
        messageHelper.setTo(to);
        messageHelper.setSubject("[" + level.toString() + "] " + " " + errorMsgs.get(0));
        if (!ccList.isEmpty()) {
            messageHelper.setCc(ccList.toArray(new String[ccList.size()]));
        }
        messageHelper.setText(this.buildMailBody(level, errorMsgs, component), false);
        this.mailSender.send(mailMessage);
        logger.info((Object)("Send Mime Message Successful to " + Arrays.asList(to).toString()));
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void sendEmail(String[] to, String subject, String email) {
        if (to == null || StringUtils.equals((String)"[]", (String)Arrays.asList(to).toString())) {
            return;
        }
        this.setupMailSenderProperties();
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setFrom(this.getFromAddress());
            message.setTo(to);
            message.setSubject(subject);
            message.setText(email);
            this.mailSender.send(message);
            logger.info((Object)("Send Simple Message Successful to " + Arrays.asList(to).toString()));
        }
        catch (Exception e) {
            logger.error((Object)("Fail to send Simple Message to " + Arrays.asList(to).toString() + " " + e));
        }
    }

    private String buildMailBody(EmailAlertLevelEnum level, List<String> errorMsgs, PluginLogComponent component) {
        StringBuilder content = new StringBuilder();
        Date currentTime = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        content.append("Time: " + df.format(currentTime) + SEPARATE);
        content.append("Serverity: " + level + SEPARATE);
        content.append("Component: " + component + SEPARATE_SYMBOL);
        content.append(StringUtils.join(errorMsgs, (String)SEPARATE_SYMBOL));
        return content.toString();
    }

    private void setupMailSenderProperties() {
        String smtpFromAddress = this.configurationServiceUtil.get("alertEmailFromAddress");
        this.mailSender.setHost(this.configurationServiceUtil.get("smtpServer"));
        this.mailSender.setUsername(smtpFromAddress);
        this.setFromAddress(smtpFromAddress);
        this.mailSender.setPort(Integer.parseInt(this.configurationServiceUtil.get("smtp.port")));
        this.setupJavaMailProperties();
    }

    private void setupJavaMailProperties() {
        Properties javaMailProperties = new Properties();
        javaMailProperties.put("mail.transport.protocol", "smtp");
        javaMailProperties.put("mail.smtp.auth", (Object)true);
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)false);
        this.mailSender.setJavaMailProperties(javaMailProperties);
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void sendAlertMail(String emailAddress, EmailAlertLevelEnum level, List<String> errorMsgs, PluginLogComponent component) {
        if (StringUtils.isBlank((String)emailAddress)) {
            return;
        }
        ArrayList<String> ccList = new ArrayList<String>();
        String[] toEmailAddress = MailUtil.extractEmailAddress(emailAddress);
        this.setupMailSenderProperties();
        try {
            this.sendMimeMessage(toEmailAddress, ccList, level, errorMsgs, component);
            logger.info((Object)("Send Alert mail to " + Arrays.asList(toEmailAddress).toString() + " successfully."));
        }
        catch (Exception e) {
            logger.error((Object)("Fail to send Alert mail to " + Arrays.asList(toEmailAddress).toString() + " " + e));
        }
    }

    @Override
    @Deprecated
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void sendAlertMail(boolean isAlert, String emailAddress, EmailAlertLevelEnum level, List<String> errorMsgs, PluginLogComponent component) {
        if (isAlert) {
            this.sendAlertMail(emailAddress, level, errorMsgs, component);
        }
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    @Autowired
    public void setConfigurationServiceUtil(ConfigurationServiceUtil configurationServiceUtil) {
        this.configurationServiceUtil = configurationServiceUtil;
    }

    @Autowired
    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }
}

