/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.service;

import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.TaskSetting;
import com.ericsson.cms.epgmgmt.service.EPGExecuteExportSetting;
import com.ericsson.cms.epgmgmt.util.ConfigurationServiceUtil;
import com.ericsson.cms.epgmgmt.utility.json.JsonUtil;
import com.ericsson.cms.epgmgmt.utility.time.CalendarUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PublishFilterSource {
    private static final String PUBLISHER_FILTERS_KEY = "PublishFilters";
    private static final String DAYS_IN_FUTURE = "daysInFuture";
    private static final String DAYS_IN_PAST = "daysInPast";
    private static final String PROGRAM_KEY = "Program";
    private static final String PROVIDER_KEY = "Provider";
    private static final String STATION_KEY = "Station";
    private static final String HEADEND_KEY = "Headend";
    private static final String SCHEDULE_TIME_KEY = "ScheduleTime";
    private static final String SCHEDULE_BY_DAY = "ByDay";
    private static final String SCHEDULE_BY_WEEK = "ByWeek";
    private static final String SCHEDULE_BY_MONTH = "ByMonth";
    private static final String INCLUDE_VALUE_KEY = "Include";
    private static final String EXCLUDE_VALUE_KEY = "Exclude";
    private static final String KEY_SPLIT_SYMBOL = "-";
    private static final String COMMA = ",";
    private ConfigurationServiceUtil configurationServiceUtil;
    private EPGExecuteExportSetting triggerSetting = null;
    private String startTime;
    private String endTime;
    private Map<String, List<String>> exportSettingMap;

    public void init(Task task) {
        if (task.isManual()) {
            this.triggerSetting = (EPGExecuteExportSetting)task.getParameter();
        }
        Set taskSetting = task.getTaskSettings();
        this.exportSettingMap = new HashMap<String, List<String>>();
        if (taskSetting == null || taskSetting.size() <= 0) {
            return;
        }
        for (TaskSetting ts : taskSetting) {
            String jasonStr;
            if (!PUBLISHER_FILTERS_KEY.equals(ts.getKey()) || StringUtils.isEmpty((String)(jasonStr = ts.getSetting()))) continue;
            this.exportSettingMap.putAll(JsonUtil.parseJsonToListMap((String)jasonStr));
        }
        this.setScheduleStartAndEndTimeFromDB();
    }

    public String getProviderId() {
        return this.getFilterSql(PROVIDER_KEY);
    }

    public String getStationId() {
        return this.getFilterSql(STATION_KEY);
    }

    public String getHeadendId() {
        return this.getFilterSql(HEADEND_KEY);
    }

    public String getExcludeProgram() {
        return this.getExportSetting(PROGRAM_KEY, EXCLUDE_VALUE_KEY);
    }

    private void setScheduleStartAndEndTimeFromDB() {
        List<String> scheduleTimeValueList = null;
        Set<String> keys = this.exportSettingMap.keySet();
        if (keys == null || keys.size() == 0) {
            return;
        }
        String dayKey = "ScheduleTime-ByDay";
        String monthKey = "ScheduleTime-ByMonth";
        String weekKey = "ScheduleTime-ByWeek";
        if (keys.contains(dayKey)) {
            scheduleTimeValueList = this.exportSettingMap.get(dayKey);
            if (scheduleTimeValueList != null && scheduleTimeValueList.size() > 0) {
                String daysInPast = scheduleTimeValueList.get(0);
                String daysInFuture = scheduleTimeValueList.get(1);
                this.startTime = CalendarUtil.getDayStart((int)Integer.parseInt(daysInPast));
                this.endTime = CalendarUtil.getDayEnd((int)Integer.parseInt(daysInFuture));
            }
        } else if (keys.contains(monthKey)) {
            scheduleTimeValueList = this.exportSettingMap.get(monthKey);
            if (scheduleTimeValueList != null && scheduleTimeValueList.size() > 0) {
                int monthDelta = Integer.parseInt(scheduleTimeValueList.get(0));
                this.startTime = CalendarUtil.getMonthStart((int)monthDelta);
                this.endTime = CalendarUtil.getMonthEnd((int)monthDelta);
            }
        } else if (keys.contains(weekKey) && (scheduleTimeValueList = this.exportSettingMap.get(weekKey)) != null && scheduleTimeValueList.size() > 0) {
            int weekDelta = Integer.parseInt(scheduleTimeValueList.get(0));
            if (weekDelta == 101) {
                this.startTime = CalendarUtil.getWeekStart((int)0);
                this.endTime = CalendarUtil.getWeekEnd((int)1);
            } else {
                this.startTime = CalendarUtil.getWeekStart((int)weekDelta);
                this.endTime = CalendarUtil.getWeekEnd((int)weekDelta);
            }
        }
    }

    private String getFilterSql(String filterKey) {
        String rest = this.getRestFilterSql(filterKey);
        if (StringUtils.isNotEmpty((String)rest)) {
            return rest;
        }
        return this.getConfigFilterSql(filterKey);
    }

    private String getRestFilterSql(String filterKey) {
        if (this.triggerSetting == null) {
            return null;
        }
        String filterSql = null;
        boolean isIncludeFilter = true;
        if (filterKey.equals(STATION_KEY)) {
            filterSql = this.restStyle2DBStyle(this.triggerSetting.getStationId());
            isIncludeFilter = this.triggerSetting.isIncludeStationIdFilter();
        } else if (filterKey.equals(HEADEND_KEY)) {
            filterSql = this.restStyle2DBStyle(this.triggerSetting.getHeadendId());
        }
        if (StringUtils.isEmpty((String)filterSql)) {
            return null;
        }
        if (isIncludeFilter) {
            return String.format(" in (%s)", filterSql);
        }
        return String.format(" not in (%s)", filterSql);
    }

    private String restStyle2DBStyle(String str) {
        Object[] array = StringUtils.split((String)str, (String)"_");
        return StringUtils.join((Object[])array, (String)COMMA);
    }

    private String getConfigFilterSql(String filterKey) {
        String includeSetting = this.getExportSetting(filterKey, INCLUDE_VALUE_KEY);
        if (StringUtils.isNotEmpty((String)includeSetting)) {
            return String.format(" in (%s)", this.addQuotesOnId(includeSetting));
        }
        String excludeSetting = this.getExportSetting(filterKey, EXCLUDE_VALUE_KEY);
        if (StringUtils.isNotEmpty((String)excludeSetting)) {
            return String.format(" not in (%s)", this.addQuotesOnId(excludeSetting));
        }
        return null;
    }

    private String addQuotesOnId(String ids) {
        String[] idArray = StringUtils.split((String)ids, (String)COMMA);
        if (idArray == null || idArray.length == 0) {
            return null;
        }
        String ret = "";
        for (String id : idArray) {
            ret = ret + "'" + id + "',";
        }
        if (ret.endsWith(COMMA)) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private String getExportSetting(String filterKey, String valueKey) {
        String keyInMap = filterKey + KEY_SPLIT_SYMBOL + valueKey;
        List<String> filterIdList = this.exportSettingMap.get(keyInMap);
        if (filterIdList != null && filterIdList.size() > 0) {
            Collections.sort(filterIdList);
        }
        return StringUtils.join(filterIdList, (String)COMMA);
    }

    public String getStartTime() {
        String queryTime;
        if (this.triggerSetting != null && StringUtils.isNotEmpty((String)(queryTime = this.triggerSetting.getStartTime()))) {
            return CalendarUtil.getUTCTime((Date)this.toDate(queryTime));
        }
        if (StringUtils.isNotEmpty((String)this.startTime)) {
            return this.startTime;
        }
        return CalendarUtil.dayInPastAsUTC((int)this.configurationServiceUtil.getInt(DAYS_IN_PAST));
    }

    public String getEndTime() {
        String queryTime;
        if (this.triggerSetting != null && StringUtils.isNotEmpty((String)(queryTime = this.triggerSetting.getEndTime()))) {
            return CalendarUtil.getUTCTime((Date)this.toDate(queryTime));
        }
        if (StringUtils.isNotEmpty((String)this.endTime)) {
            return this.endTime;
        }
        return CalendarUtil.dayInFutureAsUTC((int)this.configurationServiceUtil.getInt(DAYS_IN_FUTURE));
    }

    private Date toDate(String dataStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(dataStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Autowired
    public void setConfigurationServiceUtil(ConfigurationServiceUtil configurationServiceUtil) {
        this.configurationServiceUtil = configurationServiceUtil;
    }
}

