/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class OrderByBuilder {
    private final List<String> orderFields = new ArrayList<String>();
    private final List<String> defaultFields = new ArrayList<String>();

    public OrderByBuilder withOrder(boolean condition, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (condition) {
            this.orderFields.add(field);
        }
        return this;
    }

    public OrderByBuilder withOrder(boolean condition, String field, boolean isAsc) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (condition) {
            this.orderFields.add(field + (isAsc ? " asc" : " desc"));
        }
        return this;
    }

    public OrderByBuilder withAscOrder(boolean condition, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (condition) {
            this.orderFields.add(field + " asc");
        }
        return this;
    }

    public OrderByBuilder withDescOrder(boolean condition, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (condition) {
            this.orderFields.add(field + " desc");
        }
        return this;
    }

    public OrderByBuilder withOrder(String target, String expect, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (target != null && target.trim().equalsIgnoreCase(expect)) {
            this.orderFields.add(field);
        }
        return this;
    }

    public OrderByBuilder withOrder(String target, String expect, String field, boolean isAsc) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (target != null && target.trim().equalsIgnoreCase(expect)) {
            this.orderFields.add(field + (isAsc ? " asc" : " desc"));
        }
        return this;
    }

    public OrderByBuilder withAscOrder(String target, String expect, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (target != null && target.trim().equalsIgnoreCase(expect)) {
            this.orderFields.add(field + " asc");
        }
        return this;
    }

    public OrderByBuilder withDescOrder(String target, String expect, String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        if (target != null && target.trim().equalsIgnoreCase(expect)) {
            this.orderFields.add(field + " desc");
        }
        return this;
    }

    public OrderByBuilder withOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.orderFields.add(field);
        return this;
    }

    public OrderByBuilder withOrder(String field, boolean isAsc) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.orderFields.add(field + (isAsc ? " asc" : " desc"));
        return this;
    }

    public OrderByBuilder withAscOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.orderFields.add(field + " asc");
        return this;
    }

    public OrderByBuilder withDescOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.orderFields.add(field + " desc");
        return this;
    }

    public OrderByBuilder withDefaultOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.defaultFields.add(field);
        return this;
    }

    public OrderByBuilder withDefaultOrder(String field, boolean isAsc) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.defaultFields.add(field + (isAsc ? " asc" : " desc"));
        return this;
    }

    public OrderByBuilder withDefaultAscOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.defaultFields.add(field + " asc");
        return this;
    }

    public OrderByBuilder withDefaultDescOrder(String field) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        this.defaultFields.add(field + " desc");
        return this;
    }

    public String build() {
        if (this.orderFields.isEmpty()) {
            return this.defaultFields.isEmpty() ? "" : " ORDER BY " + StringUtils.join(this.defaultFields, (String)", ");
        }
        return " ORDER BY " + StringUtils.join(this.orderFields, (String)", ");
    }
}

