/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.sql;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class SqlBuilder {
    private String select;
    private String where;
    private String orderBy;

    public SqlBuilder withSelect(String select) {
        this.select = select;
        return this;
    }

    public String build() {
        Validate.notEmpty((String)this.select, (String)"Select clause cannot be null !");
        StringBuilder sql = new StringBuilder(this.select);
        sql.append(this.createClause(this.where, "WHERE"));
        sql.append(this.createClause(this.orderBy, "ORDER BY"));
        return sql.toString();
    }

    private String createClause(String clause, String prefix) {
        if (StringUtils.isBlank((String)clause)) {
            return "";
        }
        boolean hasWherePrefix = clause.toUpperCase().trim().startsWith(prefix.trim());
        return hasWherePrefix ? " " + clause : " " + prefix + " " + clause;
    }

    public SqlBuilder withWhere(String where) {
        this.where = where;
        return this;
    }

    public SqlBuilder withOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }
}

