/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.sql;

import org.apache.commons.lang.Validate;

public class WhereBuilder {
    private final StringBuilder sb;

    public WhereBuilder() {
        this.sb = new StringBuilder(100);
    }

    public WhereBuilder(int capacity) {
        this.sb = new StringBuilder(capacity);
    }

    public WhereBuilder withAnd(String field, String value) {
        return this.withAnd(true, field, value);
    }

    public WhereBuilder withAnd(boolean condition, String field, String value) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        Validate.notEmpty((String)value, (String)"value cannot be empty!");
        if (!condition) {
            return this;
        }
        if (this.sb.length() > 0) {
            this.sb.append(" AND ");
        }
        this.sb.append(field + "=" + "'" + value + "'");
        return this;
    }

    public WhereBuilder withAnd(boolean condition, String field, long value) {
        Validate.notEmpty((String)field, (String)"field cannot be empty!");
        Validate.notNull((Object)value, (String)"value cannot be empty!");
        if (!condition) {
            return this;
        }
        if (this.sb.length() > 0) {
            this.sb.append(" AND ");
        }
        this.sb.append(field + "=" + value);
        return this;
    }

    public WhereBuilder withAnd(boolean condition, String expression) {
        Validate.notEmpty((String)expression, (String)"expression cannot be empty!");
        if (!condition) {
            return this;
        }
        if (this.sb.length() > 0) {
            this.sb.append(" AND ");
        }
        this.sb.append(expression);
        return this;
    }

    public String build() {
        return this.sb.length() > 0 ? " WHERE " + this.sb.toString() : "";
    }
}

