/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigurationServiceUtil {
    public static final String UI_CONFIGURATION_PROPERTIES_SETTING_PATH = "com.ericsson.cms.epgmgmt.configuration";
    private static Logger logger = Logger.getLogger(ConfigurationServiceUtil.class);
    private IConfigurationService configurationService;

    public int getInt(String key) {
        String value = this.get(key);
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException("Setting is empty for Int type.");
        }
        return Integer.parseInt(value);
    }

    public String get(String key) {
        Map<Object, Object> configPublisherProperties = new HashMap();
        configPublisherProperties = this.getConfigProperties(UI_CONFIGURATION_PROPERTIES_SETTING_PATH);
        return (String)configPublisherProperties.get(key);
    }

    private Map<String, String> getConfigProperties(String configServerProperties) {
        try {
            return this.configurationService.getProperties(configServerProperties);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            logger.error((Object)"Error in retrieving EPG manager properties");
            return new HashMap<String, String>();
        }
    }

    @Autowired
    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

