/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import com.ericsson.cms.epgmgmt.entity.Endpoint;
import com.ericsson.cms.epgmgmt.entity.Task;
import com.ericsson.cms.epgmgmt.entity.enumeration.EndpointSchemeEnum;
import com.ericsson.cms.epgmgmt.plugin.EPGPluginManager;
import com.ericsson.cms.epgmgmt.plugin.PluginFactory;
import com.ericsson.epgmgr.plugin.IEPGManagerPlugin;
import com.ericsson.epgmgr.plugin.IEPGManagerPublisher;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class ExportTaskUtil {
    public static String getEndpointUri(Endpoint endpoint) {
        EndpointSchemeEnum endpointScheme = endpoint.getEndpointType();
        String providerendpointUri = null;
        String username = StringUtils.isBlank((String)endpoint.getUserName()) ? null : endpoint.getUserName();
        StringBuilder filePath = new StringBuilder("/");
        switch (endpointScheme) {
            case ftp: {
                if (endpoint.getFolder() != null) {
                    filePath.append(endpoint.getFolder());
                }
                try {
                    providerendpointUri = new URI(endpointScheme.name(), username, endpoint.getServerIp(), (int)endpoint.getPort(), filePath.toString(), ExportTaskUtil.getOptionsForEndpoint(endpoint).toString(), null).toString();
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot build the end point uri", e);
                }
            }
            case sftp: {
                if (endpoint.getFolder() != null) {
                    filePath.append(endpoint.getFolder());
                }
                try {
                    providerendpointUri = new URI(endpointScheme.name(), username, endpoint.getServerIp(), (int)endpoint.getPort(), filePath.toString(), ExportTaskUtil.getOptionsForEndpoint(endpoint).toString(), null).toString();
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot build the end point uri", e);
                }
            }
            case file: {
                try {
                    providerendpointUri = new URI(endpointScheme.name(), null, endpoint.getFolder(), -1, null, ExportTaskUtil.getOptionsForEndpoint(endpoint), null).toString();
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Cannot build the end point uri", e);
                }
            }
            default: {
                throw new IllegalArgumentException("endpoint of type - " + endpointScheme + " not supported");
            }
        }
        return providerendpointUri;
    }

    private static String getOptionsForEndpoint(Endpoint endpoint) {
        ArrayList<String> options = new ArrayList<String>(3);
        if (endpoint.getFileName() != null) {
            options.add("fileName=" + endpoint.getFileName());
        }
        if (endpoint.getEndpointType().equals((Object)EndpointSchemeEnum.ftp)) {
            options.add("maximumReconnectAttempts=0");
            options.add("disconnect=true");
            options.add("separator=UNIX");
            if (endpoint.getPassword() != null) {
                options.add("password=" + endpoint.getPassword());
            }
        }
        StringBuilder uriOptions = new StringBuilder();
        if (options.size() > 0) {
            uriOptions.append((String)options.get(0));
            options.remove(0);
        }
        for (String option : options) {
            uriOptions.append("&");
            uriOptions.append(option);
        }
        return uriOptions.toString();
    }

    public static String findETVFormatByPlugin(Task task) {
        IEPGManagerPublisher epgManagerPublisher = PluginFactory.getPublisherPlugin(task);
        Validate.notNull((Object)epgManagerPublisher, (String)("Cannot find the specified plugin in PluginFactor for " + task.getFormatName()));
        String etvFormat = EPGPluginManager.getPluginETVFormat((IEPGManagerPlugin)epgManagerPublisher);
        Validate.notNull((Object)etvFormat, (String)("Cannot find the specified ETV format in PluginFactor for " + task.getFormatName()));
        return !"ETV_20".equalsIgnoreCase(etvFormat) && !"ETV_18".equalsIgnoreCase(etvFormat) && !"ETV_MIX".equalsIgnoreCase(etvFormat) ? "ETV_20" : etvFormat.toUpperCase();
    }
}

