/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.log4j.Logger;

public class OnDemanFtpProducer
implements Processor {
    private static final Logger logger = Logger.getLogger(OnDemanFtpProducer.class);
    private final CamelContext camelContext;
    private final String ftpUri;

    public OnDemanFtpProducer(CamelContext camelContext, String uri) {
        this.camelContext = camelContext;
        this.ftpUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Endpoint ftp = null;
        Producer producer = null;
        try {
            ftp = this.camelContext.getEndpoint(this.ftpUri);
            producer = ftp.createProducer();
            producer.start();
            producer.process(exchange);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
        }
        finally {
            if (producer != null) {
                try {
                    producer.stop();
                }
                catch (Exception e) {
                    logger.error((Object)"Internal error during stop producer", (Throwable)e);
                    throw e;
                }
            }
            if (ftp != null) {
                try {
                    ftp.stop();
                    this.camelContext.removeEndpoints(this.ftpUri);
                }
                catch (Exception e) {
                    logger.error((Object)"Internal error during stop ftp endpoint", (Throwable)e);
                    throw e;
                }
            }
        }
    }
}

