/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.util;

import com.ericsson.cms.epgmgmt.utility.db.dataloader.CombinedKeyUtil;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.DataLoader;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.GeneralRowExtractor;
import com.ericsson.cms.epgmgmt.utility.db.dataloader.RowExtractor;
import com.ericsson.cms.epgmgmt.utility.db.replicator.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TableMerger {
    private static final Logger LOGGER = Logger.getLogger(TableMerger.class);
    private static final int SKIP_LEN = 2;
    private final DataSource dataSource;
    private final Table table;
    private final DataLoader prodDataLoader;
    private Map<String, Object[]> mergedRecords;
    private final boolean mergeWithEmpty;

    public TableMerger(DataSource dataSource, Table table, boolean mergeWithEmpty) {
        this.dataSource = dataSource;
        this.table = table;
        this.mergeWithEmpty = mergeWithEmpty;
        this.prodDataLoader = new DataLoader(dataSource, table.getKeys().toArray(new String[0]), null);
    }

    private Map<String, Object[]> loadDbData2Memory() {
        String selectSql = this.table.getSelectSql();
        LOGGER.info((Object)String.format("LoadDbData2Memory,selecSql=%s", selectSql));
        this.mergedRecords = this.prodDataLoader.load(selectSql, (RowExtractor)new GeneralRowExtractor()).toSimpleMap();
        return this.mergedRecords;
    }

    public void merge() {
        LOGGER.info((Object)String.format("loading %s to memory", this.table.getTableName()));
        this.loadDbData2Memory();
        LOGGER.info((Object)String.format("load %s to memory, done", this.table.getTableName()));
        String selectSql = this.table.getStgTable().getSelectSql();
        LOGGER.info((Object)("merge selectSql=" + selectSql));
        final List keys = this.table.getKeys();
        final String tableName = this.table.getTableName().toLowerCase();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        try {
            jdbcTemplate.query(selectSql, new RowMapper(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    int colCount = rs.getMetaData().getColumnCount();
                    Object[] record = new Object[colCount];
                    for (int i = 1; i <= colCount; ++i) {
                        record[i - 1] = rs.getObject(i);
                    }
                    String keyValue = CombinedKeyUtil.getCombinedKey((ResultSet)rs, (String[])keys.toArray(new String[0]));
                    TableMerger.this.mergeRecord(record, keyValue, tableName);
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)("data merge fail:" + e.getMessage()));
            throw e;
        }
    }

    public Collection<Object[]> getMergeRecord() {
        return this.mergedRecords.values();
    }

    private void mergeRecord(Object[] srcRecord, String keyValue, String tableName) {
        Object[] tunedSrcRecord = new Object[srcRecord.length + 1];
        System.arraycopy(srcRecord, 1, tunedSrcRecord, 0, srcRecord.length - 1);
        Object[] existingRecord = this.mergedRecords.get(keyValue);
        if (existingRecord == null) {
            this.touchCreateDate(tunedSrcRecord);
            this.touchUpdateDate(tunedSrcRecord);
            this.mergedRecords.put(keyValue, tunedSrcRecord);
        } else {
            this.copyCreateAndUpdateTime(existingRecord, tunedSrcRecord);
            if (this.mergeWithEmpty) {
                boolean updated = this.isRecordChanaged(tunedSrcRecord, existingRecord, 2);
                if (updated) {
                    this.touchUpdateDate(tunedSrcRecord);
                }
                this.mergedRecords.put(keyValue, tunedSrcRecord);
            } else {
                Object[] existingRecordCopy = Arrays.copyOf(existingRecord, existingRecord.length);
                this.copyNotEmptyValue(tunedSrcRecord, existingRecord, 2);
                boolean updated = this.isRecordChanaged(existingRecord, existingRecordCopy, 2);
                if (updated) {
                    this.touchUpdateDate(existingRecord);
                }
            }
        }
    }

    private void copyCreateAndUpdateTime(Object[] srcRecord, Object[] destRecord) {
        int srcLen = srcRecord.length;
        destRecord[srcLen - 2] = srcRecord[srcLen - 2];
        destRecord[srcLen - 1] = srcRecord[srcLen - 1];
    }

    private void touchCreateDate(Object[] prodRecord) {
        this.touchDate(prodRecord, prodRecord.length - 2);
    }

    private void touchUpdateDate(Object[] prodRecord) {
        this.touchDate(prodRecord, prodRecord.length - 1);
    }

    private boolean isRecordChanaged(Object[] stagRecord, Object[] prodRecord, int skipCheckLen) {
        int len = stagRecord.length - skipCheckLen;
        for (int i = 0; i < len; ++i) {
            Object stagValue = stagRecord[i];
            Object prodValue = prodRecord[i];
            if ((stagValue != null || prodValue == null) && (stagValue == null || stagValue.equals(prodValue))) continue;
            return true;
        }
        return false;
    }

    private void touchDate(Object[] prodRecord, int index) {
        Date now = new Date();
        prodRecord[index] = new Timestamp(now.getTime());
    }

    private void copyNotEmptyValue(Object[] srcRecord, Object[] destRecord, int skipScanLen) {
        int len = srcRecord.length - skipScanLen;
        for (int i = 0; i < len; ++i) {
            Object field = srcRecord[i];
            if (field == null || field.equals("")) continue;
            destRecord[i] = field;
        }
    }
}

