/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validation;

import com.ericsson.cms.epgmgmt.entity.EpgFormat;
import com.ericsson.cms.epgmgmt.util.FileUtil;
import com.ericsson.cms.epgmgmt.util.MailUtil;
import com.ericsson.cms.epgmgmt.validation.ErrorMessages;
import com.ericsson.cms.epgmgmt.validation.IGenericValidator;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.persistence.EntityManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GenericValidator
implements IGenericValidator {
    private static Logger logger = Logger.getLogger(GenericValidator.class);
    private static final Pattern FOLDER_PATTERN = Pattern.compile("[^\\@\\~#*%$#?:]+");
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static Pattern hostPattern = Pattern.compile("^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\\-\\_]*[a-zA-Z0-9])\\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\\-\\_]*[A-Za-z0-9])$", 2);
    private static Pattern DIGITAL_PATTERN = Pattern.compile("\\d+");
    private static final String EMAIL_INVALID = "epgmgmt.email.invalid";
    protected EntityManager entityManager;

    protected void validateEmailSyntax(String emailValue, List<String> errorMessages) {
        if (StringUtils.isNotBlank((String)emailValue) && !MailUtil.validateEmailAddress(emailValue)) {
            String key = MailUtil.getDelimiter(emailValue);
            if (key == null) {
                errorMessages.add(MessageFormat.format(ErrorMessages.getString(EMAIL_INVALID), emailValue));
            } else {
                String[] mailList = emailValue.split(key);
                for (int i = 0; i < mailList.length; ++i) {
                    this.validateEmail(mailList[i], errorMessages, EMAIL_INVALID);
                }
            }
        } else {
            this.validateEmail(emailValue, errorMessages, EMAIL_INVALID);
        }
    }

    public void validateEmail(String emailValue, List<String> errorMessages, String errorKey) {
        if (StringUtils.isNotBlank((String)emailValue) && emailValue.indexOf(64) == -1) {
            Object[] values = new Object[]{emailValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString(errorKey), values));
        }
    }

    public void validateNumberValue(String numberValue, List<String> errorMessages) {
        if (StringUtils.isNotBlank((String)numberValue) && !DIGITAL_PATTERN.matcher(numberValue).matches()) {
            Object[] values = new Object[]{numberValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.number.invalid"), values));
        }
    }

    public void validateFolderPathSyntax(String path, List<String> errorMessages) {
        if (StringUtils.isNotBlank((String)path) && !FOLDER_PATTERN.matcher(path).matches()) {
            Object[] values = new Object[]{path};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.path.invalid"), values));
        }
    }

    public boolean validateFolderPathPermissionForLinux(File folder, List<String> errorMessages) {
        try {
            boolean isNobody;
            boolean bl = isNobody = FileUtil.getFileOwner(folder.getCanonicalPath()).equals("nobody") && FileUtil.getFileGroup(folder.getCanonicalPath()).equals("nobody");
            if (!isNobody && !folder.canWrite()) {
                this.addError(new Object[]{folder.getCanonicalPath()}, errorMessages, "epgmgmt.path.existentDirNoPermission");
                return false;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"validateFolderPathPermissionForLinux", (Throwable)e);
        }
        return true;
    }

    public boolean validateFolderPathPermissionForLinux(String path, List<String> errorMessages) {
        return this.validateFolderPathPermissionForLinux(new File(path), errorMessages);
    }

    public boolean createFolderPath(String path, List<String> errorMessages) {
        boolean isCreated = false;
        try {
            File folder = new File(path);
            isCreated = folder.mkdirs();
        }
        catch (Exception e) {
            isCreated = false;
        }
        if (!isCreated) {
            this.addError(new Object[]{path}, errorMessages, "epgmgmt.path.dirNonCreateable");
        }
        return isCreated;
    }

    public void validateFolderPathExistsOrCreateable(String path, List<String> errorMessages) {
        if (StringUtils.isEmpty((String)path)) {
            this.addError(new Object[]{path}, errorMessages, "epgmgmt.filename.requiredField");
            return;
        }
        File folder = new File(path);
        if (folder.isFile()) {
            this.addError(new Object[]{path}, errorMessages, "epgmgmt.path.existenNonDir");
            return;
        }
        if (folder.exists()) {
            boolean isLinuxOS;
            boolean bl = isLinuxOS = !System.getProperty("os.name").toLowerCase().contains("windows");
            if (isLinuxOS) {
                this.validateFolderPathPermissionForLinux(path, errorMessages);
            }
        } else {
            this.createFolderPath(path, errorMessages);
        }
    }

    private void addError(Object[] tips, List<String> errorMessages, String key) {
        errorMessages.add(MessageFormat.format(ErrorMessages.getString(key), tips));
    }

    public void validateFileCheck(String fileCheck, List<String> errorMessages) {
        try {
            if (fileCheck != null && !fileCheck.isEmpty()) {
                Pattern.compile(fileCheck);
            }
        }
        catch (PatternSyntaxException ex) {
            Object[] values = new Object[]{fileCheck};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.fileCheck.invalid"), values));
        }
    }

    public void validateIPAddress(String ipaddress, List<String> errorMessages) {
        this.validateEPGIPAddress(ipaddress, errorMessages, "epgmgmt.ipaddress.invalid");
    }

    public void validateEPGIPAddress(String ipaddress, List<String> errorMessages, String errorKey) {
        if (ipaddress != null && !ipaddress.isEmpty()) {
            Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher matchIP = pattern.matcher(ipaddress);
            Matcher matchHost = hostPattern.matcher(ipaddress);
            if (!matchIP.matches() && !matchHost.matches()) {
                Object[] values = new Object[]{ipaddress};
                errorMessages.add(MessageFormat.format(ErrorMessages.getString(errorKey), values));
            }
        }
    }

    public void validateIntegerValue(String integerValue, List<String> errorMessages) {
        if (StringUtils.isNotBlank((String)integerValue) && !DIGITAL_PATTERN.matcher(integerValue).matches()) {
            Object[] values = new Object[]{integerValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.integer.invalid"), values));
        }
    }

    public void validateProvidernameRequiredField(String stringValue, List<String> errorMessages) {
        if (StringUtils.isBlank((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.publishername.requiredField"), values));
        }
    }

    public void validateFrequencynameRequiredField(Long longValue, List<String> errorMessages) {
        if (longValue == null || longValue <= 0L) {
            Object[] values = new Object[]{longValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.frequencyname.requiredField"), values));
        }
    }

    public void validateRetrievaltypeRequiredField(String stringValue, List<String> errorMessages) {
        if (StringUtils.isBlank((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.retrievaltype.requiredField"), values));
        }
    }

    public void validateFoldernameRequiredField(String stringValue, List<String> errorMessages) {
        if (StringUtils.isBlank((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.foldername.requiredField"), values));
        }
    }

    public void validateEpgformatRequiredField(String stringValue, List<String> errorMessages) {
        if (StringUtils.isBlank((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.requiredField"), values));
        }
    }

    public void validateEpgFormatActive(EpgFormat epgFormat, boolean isActive, List<String> errorMessages) {
        Object[] values = new Object[]{epgFormat.getFormatName()};
        if (!isActive) {
            return;
        }
        if (epgFormat.isDeleted()) {
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.deleted"), values));
            return;
        }
        if (!epgFormat.isActive()) {
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.notActive"), values));
        }
    }

    public void validateFilenameRequiredField(String stringValue, List<String> errorMessages) {
        if (StringUtils.isBlank((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.filename.requiredField"), values));
        }
    }

    public void validateFolderWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameFolder"), values));
        }
    }

    public void validateFileWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameFile"), values));
        }
    }

    public void validateFileCheckWhiteSpace(String stringValue, List<String> errorMessages) {
        if (stringValue != null && StringUtils.isWhitespace((String)stringValue)) {
            Object[] values = new Object[]{stringValue};
            errorMessages.add(MessageFormat.format(ErrorMessages.getString("epgmgmt.epgformat.whitespacenameDoneFile"), values));
        }
    }

    public void validateAlertSyntax(boolean isAlert, String emailAddress, List<String> errorMessages) {
        if (isAlert && StringUtils.isBlank((String)emailAddress)) {
            errorMessages.add(MessageFormat.format(ErrorMessages.getString(EMAIL_INVALID), emailAddress));
        }
    }
}

