/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.epgmgmt.validationrules;

import com.ericsson.cms.epgmgmt.email.MessageEntry;
import com.ericsson.cms.epgmgmt.entity.Provider;
import com.ericsson.cms.epgmgmt.entity.enumeration.EmailAlertLevelEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PartnerTypeEnum;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogComponent;
import com.ericsson.cms.epgmgmt.entity.enumeration.PluginLogSeverity;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroup;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationGroupComparator;
import com.ericsson.cms.epgmgmt.entity.rule.ValidationRule;
import com.ericsson.cms.epgmgmt.entity.rule.predicate.LogPredicate;
import com.ericsson.cms.epgmgmt.exception.ValidationRuleException;
import com.ericsson.cms.epgmgmt.job.AbstractManageableProcessor;
import com.ericsson.cms.epgmgmt.job.ThreadLocalProgressMonitor;
import com.ericsson.cms.epgmgmt.service.EpgDbStore;
import com.ericsson.cms.epgmgmt.service.IAlarmActivityLogManager;
import com.ericsson.cms.epgmgmt.service.IPartnerManager;
import com.ericsson.cms.epgmgmt.service.IValidationGroupManager;
import com.ericsson.cms.epgmgmt.util.MessageEntryUtil;
import com.ericsson.cms.epgmgmt.validationrules.IEPGRulesValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class EPGRulesValidator
extends AbstractManageableProcessor
implements IEPGRulesValidator {
    private static final String APPLY_VALIDATION_DEBUG = "applyValidationRules(long) - Applying validation rules on epg provider %d - validation rule %s, query generate - %s.";
    private static final String ERRORS_DURING_RULE_APPLY = "Applying validation rules on epg provider %s - error found while applying validation rules. error message - %s.";
    private static final String APPLY_VALIDATION_RULES = "Applying validation rules on epg provider %s - %s.";
    private static final String NO_RULES_CONFIGED_UNDER_GROUP = "Applying validation rules on epg provider %s - no rules configured for validation rule group %s.";
    private static final String GROUP_IS_NOT_ENABLED = "Applying validation rules on epg provider %s - validation rule group, %s,  is not enabled.";
    private static final String NO_VALIDATION_GROUPS_CONFIGED_OR_ENABLED = "Applying validation rules on epg provider %s - no validation rule groups either configured or enabled.";
    private static final String NO_PROVIDER_FOUND = "Applying validation rules on epg provider %d - no epg provider found in database.";
    private static final String COMPLETE_RULES_APPLY = "Applying validation rules on epg provider %s - completed applying validation rules from group %s.";
    private static final String START_RULES_APPLY = "Applying validation rules on epg provider %s - started applying validation rules from group %s.";
    private static final Logger LOGGER = Logger.getLogger(EPGRulesValidator.class);
    @Autowired
    @Qualifier(value="h2JdbcTemplate")
    private JdbcTemplate jdbcTemplate;
    private IAlarmActivityLogManager applicationLogger;
    private IPartnerManager partnerManager;
    private IValidationGroupManager validationGroupManager;
    private EpgDbStore epgDbOperation;

    @Override
    @Transactional
    public void applyValidationRules(long providerId) {
        LOGGER.debug((Object)"applyValidationRules(long) - start");
        ThreadLocalProgressMonitor.reportProgress(0);
        Provider provider = this.partnerManager.getProvider(providerId);
        if (provider == null) {
            this.addWarningLogs(String.format(NO_PROVIDER_FOUND, providerId), providerId);
            return;
        }
        List<ValidationGroup> validationGrps = this.getValidationGroups(provider);
        if (validationGrps.size() == 0) {
            this.addWarningLogs(String.format(NO_VALIDATION_GROUPS_CONFIGED_OR_ENABLED, provider.toString()), providerId);
            return;
        }
        try {
            this.setProgress(20);
            this.applyValidationGroups(provider, validationGrps);
        }
        catch (ValidationRuleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.addErrorLogs(String.format(ERRORS_DURING_RULE_APPLY, provider.toString(), ex.getMessage()), providerId);
            throw new ValidationRuleException(ex.getMessage(), (Throwable)ex);
        }
        LOGGER.debug((Object)"applyValidationRules(long) - end");
    }

    private boolean needToPerform(ValidationRule vRule, long providerId) {
        String validationQuery = vRule.getRuleAsSqlString(false);
        LOGGER.info((Object)validationQuery);
        LOGGER.debug((Object)String.format(APPLY_VALIDATION_DEBUG, providerId, vRule.getName(), validationQuery));
        if (StringUtils.isEmpty((String)validationQuery)) {
            return true;
        }
        long hitCount = this.jdbcTemplate.queryForLong(validationQuery);
        LOGGER.info((Object)("validation hit count=" + hitCount));
        return hitCount > 0L;
    }

    private void applyValidationGroups(Provider provider, List<ValidationGroup> validationGrps) {
        Collections.sort(validationGrps, new ValidationGroupComparator());
        int step = 80 / validationGrps.size();
        for (int i = 0; i < validationGrps.size(); ++i) {
            this.checkCancel();
            this.applyValidationGroup(provider, validationGrps.get(i));
            this.setProgress(20 + step * (i + 1));
        }
    }

    private void applyValidationGroup(Provider provider, ValidationGroup vGrp) {
        String groupName = vGrp.getName();
        if (!vGrp.getEnabled().booleanValue()) {
            this.addInfoLogs(String.format(GROUP_IS_NOT_ENABLED, provider.toString(), groupName), provider.getId());
            return;
        }
        List validationRules = vGrp.getRules();
        if (CollectionUtils.isEmpty((Collection)validationRules)) {
            this.addWarningLogs(String.format(NO_RULES_CONFIGED_UNDER_GROUP, provider.toString(), groupName), provider.getId());
            return;
        }
        this.addInfoLogs(String.format(START_RULES_APPLY, provider.toString(), groupName), provider.getId());
        for (ValidationRule vRule : validationRules) {
            this.checkCancel();
            this.applyValidationRule(provider, vRule);
        }
        this.addInfoLogs(String.format(COMPLETE_RULES_APPLY, provider.toString(), groupName), provider.getId());
    }

    private List<ValidationGroup> getValidationGroups(Provider provider) {
        ArrayList<ValidationGroup> validationGrps = new ArrayList<ValidationGroup>();
        validationGrps.addAll(provider.getValidationGroups());
        validationGrps.addAll(this.validationGroupManager.getAllGlobalGroups());
        return validationGrps;
    }

    private void applyValidationRule(Provider provider, ValidationRule vRule) {
        if (this.needToPerform(vRule, provider.getId())) {
            switch (((LogPredicate)vRule.getPredicate()).getErrorLevel()) {
                case INFO: {
                    this.addInfoLogs(String.format(APPLY_VALIDATION_RULES, provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage()), provider.getId());
                    break;
                }
                case WARNING: {
                    this.addWarningLogs(String.format(APPLY_VALIDATION_RULES, provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage()), provider.getId());
                    break;
                }
                case ABORT: {
                    String errorMsg = String.format(APPLY_VALIDATION_RULES, provider.toString(), ((LogPredicate)vRule.getPredicate()).getLogMessage());
                    throw new ValidationRuleException(errorMsg);
                }
            }
        }
    }

    private void addInfoLogs(String msg, long providerId) {
        this.applicationLogger.log(PluginLogSeverity.INFORMATION, PluginLogComponent.VALIDATION_RULES, msg, providerId, PartnerTypeEnum.Provider.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.INFO, "", msg, PluginLogComponent.VALIDATION_RULES));
        LOGGER.info((Object)("applyValidationRules(long) - " + msg));
    }

    private void addWarningLogs(String msg, long providerId) {
        this.applicationLogger.log(PluginLogSeverity.WARNING, PluginLogComponent.VALIDATION_RULES, msg, providerId, PartnerTypeEnum.Provider.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.WARNING, "", msg, PluginLogComponent.VALIDATION_RULES));
        LOGGER.warn((Object)("applyValidationRules(long) - " + msg));
    }

    private void addErrorLogs(String msg, long providerId) {
        this.applicationLogger.log(PluginLogSeverity.ERROR, PluginLogComponent.VALIDATION_RULES, msg, providerId, PartnerTypeEnum.Provider.toString());
        MessageEntryUtil.addMessage(new MessageEntry(EmailAlertLevelEnum.ERROR, "", msg, PluginLogComponent.VALIDATION_RULES));
        LOGGER.error((Object)("applyValidationRules(long) - " + msg));
    }

    @Autowired
    public void setApplicationLogger(IAlarmActivityLogManager applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    @Autowired
    public void setPartnerManager(IPartnerManager partnerManager) {
        this.partnerManager = partnerManager;
    }

    @Autowired
    public void setValidationGroupManager(IValidationGroupManager validationGroupManager) {
        this.validationGroupManager = validationGroupManager;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.epgDbOperation != null) {
            this.epgDbOperation.shutdownReplicator();
        }
    }

    @Override
    protected void innerProcess(Exchange exchange) {
        this.applyValidationRules(this.getPartnerId());
    }
}

